Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.73/js/components/LayoutProvider/util/fields.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es', 'dynamic-data-mapping-form-renderer/js/util/fields.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.updateFieldValidationProperty = exports.getFieldLocalizedValue = exports.getField = exports.getFieldProperty = exports.getFieldValue = exports.generateFieldName = void 0;

  var _FormSupport = require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es");

  var _fields = require("dynamic-data-mapping-form-renderer/js/util/fields.es");

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var generateFieldName = function generateFieldName(pages, desiredName) {
    var currentName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    var counter = 0;
    var name = (0, _fields.normalizeFieldName)(desiredName);
    var existingField = (0, _FormSupport.findFieldByName)(pages, name);

    while (existingField && existingField.fieldName !== currentName) {
      if (counter > 0) {
        name = (0, _fields.normalizeFieldName)(desiredName) + counter;
      }

      existingField = (0, _FormSupport.findFieldByName)(pages, name);
      counter++;
    }

    return (0, _fields.normalizeFieldName)(name);
  };

  exports.generateFieldName = generateFieldName;

  var getFieldValue = function getFieldValue(pages, fieldName) {
    return getFieldProperty(pages, fieldName, 'value');
  };

  exports.getFieldValue = getFieldValue;

  var getFieldProperty = function getFieldProperty(pages, fieldName, propertyName) {
    var visitor = new _visitors.PagesVisitor(pages);
    var propertyValue;
    visitor.mapFields(function (field) {
      if (field.fieldName === fieldName) {
        propertyValue = field[propertyName];
      }
    });
    return propertyValue;
  };

  exports.getFieldProperty = getFieldProperty;

  var getField = function getField(pages, fieldName) {
    var visitor = new _visitors.PagesVisitor(pages);
    var field;
    visitor.mapFields(function (currentField) {
      if (currentField.fieldName === fieldName) {
        field = currentField;
      }
    });
    return field;
  };

  exports.getField = getField;

  var getFieldLocalizedValue = function getFieldLocalizedValue(pages, fieldName, locale) {
    var fieldLocalizedValue = getFieldProperty(pages, fieldName, 'localizedValue');
    return fieldLocalizedValue[locale];
  };

  exports.getFieldLocalizedValue = getFieldLocalizedValue;

  var updateFieldValidationProperty = function updateFieldValidationProperty(pages, fieldName, propertyName, propertyValue) {
    var visitor = new _visitors.PagesVisitor(pages);
    return visitor.mapFields(function (field) {
      if (field.fieldName === 'validation' && field.value) {
        var expression = field.value.expression;

        if (propertyName === 'fieldName' && expression && expression.value) {
          expression.value = expression.value.replace(fieldName, propertyValue);
        }

        field = _objectSpread({}, field, {
          validation: _objectSpread({}, field.validation, _defineProperty({}, propertyName, propertyValue)),
          value: _objectSpread({}, field.value, {
            expression: expression
          })
        });
      }

      return field;
    });
  };

  exports.updateFieldValidationProperty = updateFieldValidationProperty;
  //# sourceMappingURL=fields.es.js.map
});
//# sourceMappingURL=fields.es.js.map