"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.7/js/util/fetch.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.convertToSearchParams = exports.makeFetch = void 0;

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  var defaultHeaders = {
    'Accept': 'application/json',
    'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
  };

  var makeFetch = function makeFetch(_ref) {
    var url = _ref.url,
        body = _ref.body,
        _ref$headers = _ref.headers,
        headers = _ref$headers === void 0 ? defaultHeaders : _ref$headers,
        _ref$method = _ref.method,
        method = _ref$method === void 0 ? 'POST' : _ref$method;
    var fetchData = {
      credentials: 'include',
      headers: headers,
      method: method
    };

    if (method === 'POST') {
      fetchData.body = body;
    }

    return fetch(url, fetchData).then(function (response) {
      return response.json();
    }).catch(function (error) {
      var sessionStatus = Liferay.Session.get('sessionState');

      if (sessionStatus === 'expired' || error.status === 401) {
        window.location.reload();
      }
    });
  };

  exports.makeFetch = makeFetch;

  var convertToSearchParams = function convertToSearchParams(body) {
    var searchParams = new URLSearchParams();

    if (body instanceof HTMLFormElement) {
      var formData = new FormData(body);
      formData.forEach(function (value, key) {
        return searchParams.set(key, value);
      });
    } else if (body instanceof FormData) {
      body.forEach(function (value, key) {
        return searchParams.set(key, value);
      });
    } else if (_typeof(body) === 'object') {
      Object.entries(body).forEach(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
            key = _ref3[0],
            value = _ref3[1];

        return searchParams.append(key, value);
      });
    } else {
      searchParams = body;
    }

    return searchParams;
  };

  exports.convertToSearchParams = convertToSearchParams;
  //# sourceMappingURL=fetch.es.js.map
});
//# sourceMappingURL=fetch.es.js.map