"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.7/js/components/LayoutProvider/handlers/fieldAddedHandler.es", ['module', 'exports', 'require', '../../Form/FormSupport.es', '../../../util/fieldSupport.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var FormSupport = _interopRequireWildcard(require("../../Form/FormSupport.es"));

  var _fieldSupport = require("../../../util/fieldSupport.es");

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj.default = obj;return newObj;
    }
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};var ownKeys = Object.keys(source);if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var handleFieldAdded = function handleFieldAdded(props, state, event) {
    var addedToPlaceholder = event.addedToPlaceholder,
        focusedField = event.focusedField,
        target = event.target;
    var fieldName = focusedField.fieldName,
        name = focusedField.name,
        settingsContext = focusedField.settingsContext;
    var pageIndex = target.pageIndex,
        rowIndex = target.rowIndex;
    var defaultLanguageId = props.defaultLanguageId,
        editingLanguageId = props.editingLanguageId,
        spritemap = props.spritemap;
    var pages = state.pages;
    var columnIndex = target.columnIndex;

    var fieldProperties = _objectSpread({}, (0, _fieldSupport.getFieldProperties)(settingsContext, defaultLanguageId, editingLanguageId), {
      fieldName: fieldName,
      instanceId: (0, _fieldSupport.generateInstanceId)(8),
      name: name,
      settingsContext: settingsContext,
      spritemap: spritemap,
      type: name
    });

    if (addedToPlaceholder) {
      pages = FormSupport.addRow(pages, rowIndex, pageIndex);
      columnIndex = 0;
    }

    return {
      focusedField: _objectSpread({}, fieldProperties, {
        columnIndex: columnIndex,
        originalContext: fieldProperties,
        pageIndex: pageIndex,
        rowIndex: rowIndex
      }),
      pages: FormSupport.addFieldToColumn(pages, pageIndex, rowIndex, columnIndex, fieldProperties)
    };
  };

  var _default = handleFieldAdded;
  exports.default = _default;
  //# sourceMappingURL=fieldAddedHandler.es.js.map
});
//# sourceMappingURL=fieldAddedHandler.es.js.map