/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.servlet;

import com.liferay.dynamic.data.mapping.form.builder.internal.servlet.BaseDDMFormBuilderServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.RoleService;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import java.io.IOException;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"dynamic.data.mapping.form.builder.servlet=true", "osgi.http.whiteboard.context.path=/dynamic-data-mapping-form-builder-roles", "osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.RolesServlet", "osgi.http.whiteboard.servlet.pattern=/dynamic-data-mapping-form-builder-roles/*"}, service={Servlet.class})
public class RolesServlet
extends BaseDDMFormBuilderServlet {
    private static final Log _log = LogFactoryUtil.getLog(RolesServlet.class);
    private static final long serialVersionUID = 1L;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private RoleService _roleService;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JSONArray jsonArray = this.getRolesJSONArray();
        response.setContentType("application/json");
        response.setStatus(200);
        ServletResponseUtil.write((HttpServletResponse)response, (String)jsonArray.toJSONString());
    }

    protected JSONArray getRolesJSONArray() {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        try {
            List roles = this._roleService.getRoles(CompanyThreadLocal.getCompanyId().longValue(), null);
            for (Role role : roles) {
                jsonArray.put(this.toJSONObject(role));
            }
            return jsonArray;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return jsonArray;
        }
    }

    protected JSONObject toJSONObject(Role role) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        jsonObject.put("id", role.getRoleId()).put("name", role.getName());
        return jsonObject;
    }
}

