Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.59/js/components/LayoutProvider/handlers/fieldDuplicatedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', '../../../util/strings.es', '../util/fields.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var FormSupport = _interopRequireWildcard(require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es"));

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _strings = require("../../../util/strings.es");

  var _fields = require("../util/fields.es");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var handleFieldDuplicated = function handleFieldDuplicated(_ref, state, event) {
    var editingLanguageId = _ref.editingLanguageId,
        fieldNameGenerator = _ref.fieldNameGenerator;
    var _event$indexes = event.indexes,
        columnIndex = _event$indexes.columnIndex,
        pageIndex = _event$indexes.pageIndex,
        rowIndex = _event$indexes.rowIndex;
    var pages = state.pages;
    var field = FormSupport.getField(pages, pageIndex, rowIndex, columnIndex);
    var localizedLabel = (0, _fields.getFieldLocalizedValue)(field.settingsContext.pages, 'label', editingLanguageId);
    var label = (0, _strings.sub)(Liferay.Language.get('copy-of-x'), [localizedLabel]);
    var newFieldName = fieldNameGenerator(label);
    var oldFieldName = field.fieldName;
    var visitor = new _visitors.PagesVisitor(field.settingsContext.pages);

    var duplicatedField = _objectSpread({}, field, {
      fieldName: newFieldName,
      label: label,
      name: newFieldName,
      settingsContext: _objectSpread({}, field.settingsContext, {
        pages: visitor.mapFields(function (field) {
          if (field.fieldName === 'name') {
            field = _objectSpread({}, field, {
              value: newFieldName
            });
          } else if (field.fieldName === 'label') {
            field = _objectSpread({}, field, {
              localizedValue: _objectSpread({}, field.localizedValue, _defineProperty({}, editingLanguageId, label)),
              value: label
            });
          } else if (field.fieldName === 'validation') {
            var expression = field.value.expression;

            if (expression && expression.value) {
              field = _objectSpread({}, field, {
                value: _objectSpread({}, field.value, {
                  expression: _objectSpread({}, field.value.expression, {
                    value: expression.value.replace(oldFieldName, newFieldName)
                  })
                })
              });
            }
          }

          return _objectSpread({}, field);
        })
      })
    });

    var newRowIndex = rowIndex + 1;
    var newRow = FormSupport.implAddRow(12, [duplicatedField]);
    return {
      focusedField: _objectSpread({}, duplicatedField, {
        columnIndex: columnIndex,
        pageIndex: pageIndex,
        rowIndex: newRowIndex
      }),
      pages: FormSupport.addRow(pages, newRowIndex, pageIndex, newRow)
    };
  };

  var _default = handleFieldDuplicated;
  exports["default"] = _default;
  //# sourceMappingURL=fieldDuplicatedHandler.es.js.map
});
//# sourceMappingURL=fieldDuplicatedHandler.es.js.map