/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import * as FormSupport from 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es';

import {updateFocusedField} from '../util/focusedField.es';
import {updateRulesReferences} from '../util/rules.es';

export const updatePages = (pages, oldFieldProperties, newFieldProperties) => {
	const {fieldName} = oldFieldProperties;

	return FormSupport.updateField(pages, fieldName, newFieldProperties);
};

export const updateField = (props, state, fieldName, fieldValue) => {
	const {focusedField, pages, rules} = state;
	const updatedFocusedField = updateFocusedField(
		props,
		state,
		fieldName,
		fieldValue
	);

	return {
		focusedField: updatedFocusedField,
		pages: updatePages(pages, focusedField, updatedFocusedField),
		rules: updateRulesReferences(
			rules || [],
			focusedField,
			updatedFocusedField
		)
	};
};

export const handleFieldEdited = (props, state, event) => {
	const {propertyName, propertyValue} = event;
	let newState = {};

	if (propertyName !== 'name' || propertyValue !== '') {
		newState = updateField(props, state, propertyName, propertyValue);
	}

	return newState;
};

export default handleFieldEdited;
