Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.46/js/components/LayoutProvider/handlers/fieldClickedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var FormSupport = _interopRequireWildcard(require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es"));

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var handleFieldClicked = function handleFieldClicked(state, event) {
    var columnIndex = event.columnIndex,
        pageIndex = event.pageIndex,
        rowIndex = event.rowIndex;
    var pages = state.pages;
    var fieldProperties = FormSupport.getField(pages, pageIndex, rowIndex, columnIndex);
    var settingsContext = fieldProperties.settingsContext;
    var visitor = new _visitors.PagesVisitor(settingsContext.pages);

    var focusedField = _objectSpread({}, fieldProperties, {
      columnIndex: columnIndex,
      pageIndex: pageIndex,
      rowIndex: rowIndex,
      settingsContext: _objectSpread({}, settingsContext, {
        pages: visitor.mapFields(function (field) {
          var _field = field,
              fieldName = _field.fieldName;

          if (fieldName === 'name') {
            field.visible = true;
          } else if (fieldName === 'label') {
            field.type = 'text';
          } else if (fieldName === 'validation') {
            field = _objectSpread({}, field, {
              validation: _objectSpread({}, field.validation, {
                fieldName: fieldProperties.fieldName
              })
            });
          }

          return field;
        })
      })
    });

    return {
      focusedField: _objectSpread({}, focusedField, {
        columnIndex: columnIndex,
        pageIndex: pageIndex,
        rowIndex: rowIndex
      }),
      previousFocusedField: focusedField
    };
  };

  var _default = handleFieldClicked;
  exports["default"] = _default;
  //# sourceMappingURL=fieldClickedHandler.es.js.map
});
//# sourceMappingURL=fieldClickedHandler.es.js.map