/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import FormRenderer from './FormRenderer.es';
import {PagesVisitor} from 'dynamic-data-mapping-form-builder/js/util/visitors.es';

class FormRendererWithProvider extends FormRenderer {
	_handleFieldEdited(properties) {
		const pageVisitor = new PagesVisitor(this.pages);

		const pages = pageVisitor.mapFields(field => {
			if (field.fieldName === properties.fieldInstance.fieldName) {
				return {
					...field,
					value: properties.value
				};
			}
		});

		this.pages = pages;
	}

	created() {
		this.on('fieldEdited', this._handleFieldEdited);
	}
}

export default FormRendererWithProvider;
