/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.servlet;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunctionTracker;
import com.liferay.dynamic.data.mapping.form.builder.internal.servlet.BaseDDMFormBuilderServlet;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"dynamic.data.mapping.form.builder.servlet=true", "osgi.http.whiteboard.context.path=/dynamic-data-mapping-form-builder-functions", "osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMFormFunctionsServlet", "osgi.http.whiteboard.servlet.pattern=/dynamic-data-mapping-form-builder-functions/*"}, service={Servlet.class})
public class DDMFormFunctionsServlet
extends BaseDDMFormBuilderServlet {
    private static final long serialVersionUID = 1L;
    @Reference
    private DDMExpressionFunctionTracker _ddmExpressionFunctionTracker;
    @Reference
    private JSONFactory _jsonFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Map<String, DDMExpressionFunction> ddmExpressionFunctions = null;
        try {
            ddmExpressionFunctions = this.getDDMExpressionFunctions();
            String languageId = ParamUtil.getString((HttpServletRequest)request, (String)"languageId");
            JSONArray jsonArray = this.toJSONArray(ddmExpressionFunctions.entrySet(), LocaleUtil.fromLanguageId((String)languageId));
            response.setContentType("application/json");
            response.setStatus(200);
            ServletResponseUtil.write((HttpServletResponse)response, (String)jsonArray.toJSONString());
        }
        finally {
            if (ddmExpressionFunctions != null) {
                this._ddmExpressionFunctionTracker.ungetDDMExpressionFunctions(ddmExpressionFunctions);
            }
        }
    }

    protected Map<String, DDMExpressionFunction> getDDMExpressionFunctions() {
        HashSet<String> functionNames = new HashSet<String>();
        functionNames.add("sum");
        return this._ddmExpressionFunctionTracker.getDDMExpressionFunctions(functionNames);
    }

    protected JSONArray toJSONArray(Set<Map.Entry<String, DDMExpressionFunction>> entries, Locale locale) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, ((Object)((Object)this)).getClass());
        for (Map.Entry<String, DDMExpressionFunction> entry : entries) {
            jsonArray.put(this.toJSONObject(entry, resourceBundle));
        }
        return jsonArray;
    }

    protected JSONObject toJSONObject(Map.Entry<String, DDMExpressionFunction> entry, ResourceBundle resourceBundle) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        String key = entry.getKey();
        String labelLanguageKey = key + '_' + "function";
        jsonObject.put("label", LanguageUtil.get((ResourceBundle)resourceBundle, (String)labelLanguageKey));
        jsonObject.put("value", key);
        String tooltipLanguageKey = key + '_' + "tooltip";
        jsonObject.put("tooltip", LanguageUtil.get((ResourceBundle)resourceBundle, (String)tooltipLanguageKey));
        return jsonObject;
    }
}

