"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.18/js/components/LayoutProvider/util/rules.es", ['module', 'exports', 'require', '../../../expressions/Token.es', '../../../expressions/Tokenizer.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.updateRulesFieldName = exports.renameFieldInsideExpression = void 0;

  var _Token = _interopRequireDefault(require("../../../expressions/Token.es"));

  var _Tokenizer = _interopRequireDefault(require("../../../expressions/Tokenizer.es"));

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};var ownKeys = Object.keys(source);if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var renameFieldInsideExpression = function renameFieldInsideExpression(expression, fieldName, newFieldName) {
    var tokens = _Tokenizer.default.tokenize(expression);

    return _Tokenizer.default.stringifyTokens(tokens.map(function (token) {
      if (token.type === _Token.default.VARIABLE && token.value === fieldName) {
        token = new _Token.default(_Token.default.VARIABLE, newFieldName);
      }

      return token;
    }));
  };

  exports.renameFieldInsideExpression = renameFieldInsideExpression;

  var updateRulesFieldName = function updateRulesFieldName(rules, fieldName, newFieldName) {
    var visitor = new _visitors.RulesVisitor(rules);
    rules = visitor.mapActions(function (action) {
      if (action.target === fieldName) {
        action = _objectSpread({}, action, {
          target: newFieldName
        });
      }

      if (action.action === 'calculate') {
        action = _objectSpread({}, action, {
          expression: renameFieldInsideExpression(action.expression, fieldName, newFieldName)
        });
      }

      return action;
    });
    visitor.setRules(rules);
    return visitor.mapConditions(function (condition) {
      return _objectSpread({}, condition, {
        operands: condition.operands.map(function (operand) {
          if (operand.type === 'field' && operand.value === fieldName) {
            operand = _objectSpread({}, operand, {
              value: newFieldName
            });
          }

          return operand;
        })
      });
    });
  };

  exports.updateRulesFieldName = updateRulesFieldName;
  //# sourceMappingURL=rules.es.js.map
});
//# sourceMappingURL=rules.es.js.map