"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.18/js/components/LayoutProvider/handlers/fieldSetAddedHandler.es", ['module', 'exports', 'require', '../util/fields.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var _fields = require("../util/fields.es");

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};var ownKeys = Object.keys(source);if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var handleFieldSetAdded = function handleFieldSetAdded(props, state, event) {
    var fieldSetPages = event.fieldSetPages,
        target = event.target;
    var pages = state.pages;
    var pageIndex = target.pageIndex,
        rowIndex = target.rowIndex;
    var visitor = new _visitors.PagesVisitor(fieldSetPages);
    var newFieldsetPages = visitor.mapFields(function (field) {
      var name = (0, _fields.generateFieldName)(pages, field.fieldName);
      var settingsContextVisitor = new _visitors.PagesVisitor(field.settingsContext.pages);
      return _objectSpread({}, field, {
        fieldName: name,
        settingsContext: _objectSpread({}, field.settingsContext, {
          pages: settingsContextVisitor.mapFields(function (settingsContextField) {
            if (settingsContextField.fieldName === 'name') {
              settingsContextField = _objectSpread({}, settingsContextField, {
                value: name
              });
            }

            return settingsContextField;
          })
        })
      });
    });
    var rows = newFieldsetPages[0].rows;

    for (var i = rows.length - 1; i >= 0; i--) {
      pages[pageIndex].rows.splice(rowIndex, 0, rows[i]);
    }

    return {
      pages: pages
    };
  };

  var _default = handleFieldSetAdded;
  exports.default = _default;
  //# sourceMappingURL=fieldSetAddedHandler.es.js.map
});
//# sourceMappingURL=fieldSetAddedHandler.es.js.map