"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.18/js/components/LayoutProvider/handlers/fieldDuplicatedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es', '../util/fields.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', '../../../util/strings.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var FormSupport = _interopRequireWildcard(require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es"));

  var _fields = require("../util/fields.es");

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _strings = require("../../../util/strings.es");

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj.default = obj;return newObj;
    }
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};var ownKeys = Object.keys(source);if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var handleFieldDuplicated = function handleFieldDuplicated(state, editingLanguageId, event) {
    var _event$indexes = event.indexes,
        columnIndex = _event$indexes.columnIndex,
        pageIndex = _event$indexes.pageIndex,
        rowIndex = _event$indexes.rowIndex;
    var pages = state.pages;
    var field = FormSupport.getField(pages, pageIndex, rowIndex, columnIndex);
    var localizedLabel = (0, _fields.getFieldLocalizedValue)(field.settingsContext.pages, 'label', editingLanguageId);
    var label = (0, _strings.sub)(Liferay.Language.get('copy-of-x'), [localizedLabel]);
    var newFieldName = (0, _fields.generateFieldName)(pages, label);
    var visitor = new _visitors.PagesVisitor(field.settingsContext.pages);

    var duplicatedField = _objectSpread({}, field, {
      fieldName: newFieldName,
      label: label,
      name: newFieldName,
      settingsContext: _objectSpread({}, field.settingsContext, {
        pages: visitor.mapFields(function (field) {
          if (field.fieldName === 'name') {
            field = _objectSpread({}, field, {
              value: newFieldName
            });
          } else if (field.fieldName === 'label') {
            field = _objectSpread({}, field, {
              localizedValue: _objectSpread({}, field.localizedValue, _defineProperty({}, editingLanguageId, label)),
              value: label
            });
          }

          return _objectSpread({}, field);
        })
      })
    });

    var newRowIndex = rowIndex + 1;
    var newRow = FormSupport.implAddRow(12, [duplicatedField]);
    return {
      focusedField: _objectSpread({}, duplicatedField, {
        columnIndex: columnIndex,
        pageIndex: pageIndex,
        rowIndex: newRowIndex
      }),
      pages: FormSupport.addRow(pages, newRowIndex, pageIndex, newRow)
    };
  };

  var _default = handleFieldDuplicated;
  exports.default = _default;
  //# sourceMappingURL=fieldDuplicatedHandler.es.js.map
});
//# sourceMappingURL=fieldDuplicatedHandler.es.js.map