"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.15/js/components/LayoutProvider/handlers/fieldEditedHandler.es", ['module', 'exports', 'require', '../../Form/FormSupport.es', '../util/focusedField.es', '../util/rules.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.handleFieldEdited = exports.updateField = exports.updateRules = exports.updatePages = void 0;

  var FormSupport = _interopRequireWildcard(require("../../Form/FormSupport.es"));

  var _focusedField = require("../util/focusedField.es");

  var _rules = require("../util/rules.es");

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj.default = obj;return newObj;
    }
  }

  var updatePages = function updatePages(pages, oldFieldProperties, newFieldProperties) {
    var fieldName = oldFieldProperties.fieldName;
    return FormSupport.updateField(pages, fieldName, newFieldProperties);
  };

  exports.updatePages = updatePages;

  var updateRules = function updateRules(rules, oldFieldProperties, newFieldProperties) {
    var fieldName = oldFieldProperties.fieldName;
    var newFieldName = newFieldProperties.fieldName;
    return (0, _rules.updateRulesFieldName)(rules, fieldName, newFieldName);
  };

  exports.updateRules = updateRules;

  var updateField = function updateField(state, defaultLanguageId, editingLanguageId, fieldName, fieldValue) {
    var focusedField = state.focusedField,
        pages = state.pages,
        rules = state.rules;
    var updatedFocusedField = (0, _focusedField.updateFocusedField)(state, defaultLanguageId, editingLanguageId, fieldName, fieldValue);
    return {
      focusedField: updatedFocusedField,
      pages: updatePages(pages, focusedField, updatedFocusedField),
      rules: updateRules(rules, focusedField, updatedFocusedField)
    };
  };

  exports.updateField = updateField;

  var handleFieldEdited = function handleFieldEdited(state, defaultLanguageId, editingLanguageId, event) {
    var propertyName = event.propertyName,
        propertyValue = event.propertyValue;
    var newState = {};

    if (propertyName !== 'name' || propertyValue !== '') {
      newState = updateField(state, defaultLanguageId, editingLanguageId, propertyName, propertyValue);
    }

    return newState;
  };

  exports.handleFieldEdited = handleFieldEdited;
  var _default = handleFieldEdited;
  exports.default = _default;
  //# sourceMappingURL=fieldEditedHandler.es.js.map
});
//# sourceMappingURL=fieldEditedHandler.es.js.map