"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.15/js/components/FormBuilder/withMultiplePages.es", ['module', 'exports', 'require', '../SuccessPage/SuccessPagePaginationItem.soy', '../SuccessPage/SuccessPageRenderer.soy', '../SuccessPage/SuccessPageWizardItem.soy', 'frontend-js-metal-web$metal-jsx', 'frontend-taglib-clay$clay-dropdown', 'frontend-js-metal-web$metal-state', '../../util/config.es', '../../util/i18n.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  require("../SuccessPage/SuccessPagePaginationItem.soy");

  require("../SuccessPage/SuccessPageRenderer.soy");

  require("../SuccessPage/SuccessPageWizardItem.soy");

  var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

  var _clayDropdown = require("frontend-taglib-clay$clay-dropdown");

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _config = require("../../util/config.es");

  var _i18n = require("../../util/i18n.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var withMultiplePages = function withMultiplePages(ChildComponent) {
    var MultiplePages =
    /*#__PURE__*/
    function (_Component) {
      _inherits(MultiplePages, _Component);

      function MultiplePages() {
        _classCallCheck(this, MultiplePages);

        return _possibleConstructorReturn(this, _getPrototypeOf(MultiplePages).apply(this, arguments));
      }

      _createClass(MultiplePages, [{
        key: "getPages",
        value: function getPages() {
          var pages = this.props.pages;
          var successPageSettings = this.props.successPageSettings;

          if (successPageSettings.enabled) {
            pages = [].concat(_toConsumableArray(pages), [{
              contentRenderer: 'success',
              paginationItemRenderer: 'success',
              rows: [],
              successPageSettings: successPageSettings
            }]);
          }

          return pages;
        }
      }, {
        key: "getPaginationPosition",
        value: function getPaginationPosition() {
          var _this$props = this.props,
              pages = _this$props.pages,
              paginationMode = _this$props.paginationMode;
          var position = paginationMode === 'wizard' ? 'top' : 'bottom';
          return pages.length > 1 ? position : 'top';
        }
      }, {
        key: "isDropdownDisabled",
        value: function isDropdownDisabled() {
          var _this$props2 = this.props,
              defaultLanguageId = _this$props2.defaultLanguageId,
              editingLanguageId = _this$props2.editingLanguageId;
          return defaultLanguageId !== editingLanguageId;
        }
      }, {
        key: "render",
        value: function render() {
          var dropdownExpanded = this.state.dropdownExpanded;
          var _this$props3 = this.props,
              spritemap = _this$props3.spritemap,
              view = _this$props3.view;
          IncrementalDOM.elementOpen("div", null, null, "class", "container ddm-paginated-builder ".concat(this.getPaginationPosition()));
          IncrementalDOM.elementOpenStart(ChildComponent);
          iDOMHelpers.forOwn(this.props, iDOMHelpers.attr);
          IncrementalDOM.attr("pages", this.getPages());
          IncrementalDOM.elementOpenEnd(ChildComponent);
          IncrementalDOM.elementClose(ChildComponent);
          iDOMHelpers.renderArbitrary(view !== 'fieldSets' && IncrementalDOM.elementVoid(_clayDropdown.ClayActionsDropdown, null, null, "disabled", this.isDropdownDisabled(), "events", {
            expandedChanged: this._handleExpandedChanged.bind(this),
            itemClicked: this._handleDropdownItemClicked.bind(this)
          }, "expanded", dropdownExpanded, "items", this._getPageSettingsItems(), "spritemap", spritemap, "elementClasses", 'ddm-paginated-builder-dropdown'));
          return IncrementalDOM.elementClose("div");
        }
      }, {
        key: "_addPage",
        value: function _addPage() {
          var dispatch = this.context.dispatch;
          dispatch('pageAdded');
        }
      }, {
        key: "_addSuccessPage",
        value: function _addSuccessPage() {
          var dispatch = this.context.dispatch;
          var pages = this.props.pages;

          this._updateSuccessPage({
            body: Liferay.Language.get('your-information-was-successfully-received-thanks-for-fill-out'),
            enabled: true,
            title: Liferay.Language.get('done')
          });

          dispatch('activePageUpdated', pages.length);
        }
      }, {
        key: "_deletePage",
        value: function _deletePage() {
          var dispatch = this.context.dispatch;
          dispatch('pageDeleted', this.props.activePage);
        }
      }, {
        key: "_deleteSuccessPage",
        value: function _deleteSuccessPage() {
          var dispatch = this.context.dispatch;

          this._updateSuccessPage({
            enabled: false
          });

          dispatch('activePageUpdated', this.props.pages.length - 1);
        }
      }, {
        key: "_getPageSettingsItems",
        value: function _getPageSettingsItems() {
          var _this$props4 = this.props,
              pages = _this$props4.pages,
              paginationMode = _this$props4.paginationMode,
              successPageSettings = _this$props4.successPageSettings;
          var pageSettingsItems = [{
            'label': Liferay.Language.get('add-new-page'),
            'settingsItem': 'add-page'
          }];

          if (this.getPages().length === 1) {
            pageSettingsItems.push({
              'label': Liferay.Language.get('reset-page'),
              'settingsItem': 'reset-page'
            });
          } else {
            pageSettingsItems.push({
              'label': Liferay.Language.get('delete-current-page'),
              'settingsItem': 'delete-page'
            });
          }

          if (!successPageSettings.enabled) {
            pageSettingsItems.push({
              'label': Liferay.Language.get('add-success-page'),
              'settingsItem': 'add-success-page'
            });
          }

          if (pages.length > 1) {
            var label = Liferay.Language.get('switch-pagination-to-top');

            if (paginationMode == 'wizard') {
              label = Liferay.Language.get('switch-pagination-to-bottom');
            }

            pageSettingsItems.push({
              label: label,
              settingsItem: 'switch-pagination-mode'
            });
          }

          return pageSettingsItems;
        }
      }, {
        key: "_handleDropdownItemClicked",
        value: function _handleDropdownItemClicked(_ref) {
          var data = _ref.data;
          var _this$props5 = this.props,
              activePage = _this$props5.activePage,
              successPageSettings = _this$props5.successPageSettings;
          var settingsItem = data.item.settingsItem;
          this.setState({
            dropdownExpanded: false
          });

          if (settingsItem == 'add-page') {
            this._addPage();
          } else if (settingsItem === 'reset-page') {
            this._resetPage();
          } else if (settingsItem === 'delete-page') {
            if (successPageSettings.enabled && activePage == this.getPages().length - 1) {
              this._deleteSuccessPage();
            } else {
              this._deletePage();
            }
          } else if (settingsItem == 'switch-pagination-mode') {
            this._switchPaginationMode();
          } else if (settingsItem == 'add-success-page') {
            this._addSuccessPage();
          }
        }
      }, {
        key: "_handleExpandedChanged",
        value: function _handleExpandedChanged(_ref2) {
          var newVal = _ref2.newVal;
          this.setState({
            dropdownExpanded: newVal
          });
        }
      }, {
        key: "_resetPage",
        value: function _resetPage() {
          var dispatch = this.context.dispatch;
          dispatch('pageReset');
        }
      }, {
        key: "_switchPaginationMode",
        value: function _switchPaginationMode() {
          var dispatch = this.context.dispatch;
          dispatch('paginationModeUpdated');
        }
      }, {
        key: "_updateSuccessPage",
        value: function _updateSuccessPage(_ref3) {
          var _ref3$body = _ref3.body,
              body = _ref3$body === void 0 ? '' : _ref3$body,
              _ref3$title = _ref3.title,
              title = _ref3$title === void 0 ? '' : _ref3$title,
              enabled = _ref3.enabled;
          var dispatch = this.context.dispatch;
          var editingLanguageId = this.props.editingLanguageId;
          var successPageSettings = {
            body: {},
            enabled: enabled,
            title: {}
          };
          (0, _i18n.setValue)(successPageSettings, editingLanguageId, 'body', body);
          (0, _i18n.setValue)(successPageSettings, editingLanguageId, 'title', title);
          dispatch('successPageChanged', successPageSettings);
        }
      }]);

      return MultiplePages;
    }(_metalJsx.default);

    _defineProperty(MultiplePages, "PROPS", {
      /**
       * @default
       * @instance
       * @memberof FormBuilder
       * @type {?number}
       */
      activePage: _metalState.Config.number().value(0),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      defaultLanguageId: _metalState.Config.string(),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      editingLanguageId: _metalState.Config.string(),

      /**
       * @default []
       * @instance
       * @memberof Sidebar
       * @type {?(array|undefined)}
       */
      fieldTypes: _metalState.Config.array().value([]),

      /**
       * @default {}
       * @instance
       * @memberof FormBuilder
       * @type {?object}
       */
      focusedField: _config.focusedFieldStructure.value({}),

      /**
       * @default []
       * @instance
       * @memberof FormBuilder
       * @type {?array<object>}
       */
      pages: _metalState.Config.arrayOf(_config.pageStructure).value([]),

      /**
       * @instance
       * @memberof FormBuilder
       * @type {string}
       */
      paginationMode: _metalState.Config.string().required(),

      /**
       * @instance
       * @memberof FormBuilder
       * @type {string}
       */
      rules: _metalState.Config.arrayOf(_config.ruleStructure).required(),

      /**
       * @default undefined
       * @instance
       * @memberof FormRenderer
       * @type {!string}
       */
      spritemap: _metalState.Config.string().required(),

      /**
       * @instance
       * @memberof MultiplePages
       * @type {object}
       */
      successPageSettings: _metalState.Config.shapeOf({
        body: _metalState.Config.object(),
        enabled: _metalState.Config.bool(),
        title: _metalState.Config.object()
      }).value({})
    });

    _defineProperty(MultiplePages, "STATE", {
      /**
       * @default false
       * @instance
       * @memberof FormRenderer
       * @type {boolean}
       */
      dropdownExpanded: _metalState.Config.bool().value(false).internal()
    });

    return MultiplePages;
  };

  var _default = withMultiplePages;
  exports.default = _default;
  //# sourceMappingURL=withMultiplePages.es.js.map
});
//# sourceMappingURL=withMultiplePages.es.js.map