"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.15/js/components/FormBuilder/withActionableFields.es", ['module', 'exports', 'require', '../Form/FormSupport.es', 'frontend-taglib-clay$clay-button', 'frontend-taglib-clay$clay-modal', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-events', '../../util/config.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var FormSupport = _interopRequireWildcard(require("../Form/FormSupport.es"));

  var _clayButton = _interopRequireDefault(require("frontend-taglib-clay$clay-button"));

  var _clayModal = _interopRequireDefault(require("frontend-taglib-clay$clay-modal"));

  var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  var _config = require("../../util/config.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj.default = obj;return newObj;
    }
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var Actions =
  /*#__PURE__*/
  function (_Component) {
    _inherits(Actions, _Component);

    function Actions() {
      _classCallCheck(this, Actions);

      return _possibleConstructorReturn(this, _getPrototypeOf(Actions).apply(this, arguments));
    }

    _createClass(Actions, [{
      key: "render",
      value: function render() {
        var spritemap = this.props.spritemap;
        IncrementalDOM.elementOpen("div", null, null, "class", "ddm-field-actions-container", "ref", "actionsContainer");
        IncrementalDOM.elementVoid(_clayButton.default, null, null, "events", {
          click: this._handleDuplicateButtonClicked.bind(this)
        }, "spritemap", spritemap, "editable", true, "icon", "paste", "monospaced", true, "size", "sm", "style", "secondary");
        IncrementalDOM.elementVoid(_clayButton.default, null, null, "events", {
          click: this._handleDeleteButtonClicked.bind(this)
        }, "spritemap", spritemap, "editable", true, "icon", "trash", "monospaced", true, "size", "sm", "style", "secondary");
        return IncrementalDOM.elementClose("div");
      }
    }, {
      key: "_handleDeleteButtonClicked",
      value: function _handleDeleteButtonClicked(event) {
        var indexes = FormSupport.getIndexes(_metalDom.default.closest(event.target, '.col-ddm'));
        this.emit('fieldDeleted', {
          indexes: indexes
        });
      }
    }, {
      key: "_handleDuplicateButtonClicked",
      value: function _handleDuplicateButtonClicked(event) {
        var indexes = FormSupport.getIndexes(_metalDom.default.closest(event.target, '.col-ddm'));
        this.emit('fieldDuplicated', {
          indexes: indexes
        });
      }
    }]);

    return Actions;
  }(_metalJsx.default);

  var withActionableFields = function withActionableFields(ChildComponent) {
    var ActionableFields =
    /*#__PURE__*/
    function (_Component2) {
      _inherits(ActionableFields, _Component2);

      function ActionableFields() {
        _classCallCheck(this, ActionableFields);

        return _possibleConstructorReturn(this, _getPrototypeOf(ActionableFields).apply(this, arguments));
      }

      _createClass(ActionableFields, [{
        key: "attached",
        value: function attached() {
          this._eventHandler = new _metalEvents.EventHandler();

          this._eventHandler.add(this.delegate('mouseenter', '.ddm-field-container', this._handleMouseEnterField.bind(this)));
        }
      }, {
        key: "disposeInternal",
        value: function disposeInternal() {
          _get(_getPrototypeOf(ActionableFields.prototype), "disposeInternal", this).call(this);

          this._eventHandler.removeAllListeners();
        }
      }, {
        key: "getEvents",
        value: function getEvents() {
          return {
            fieldDeleted: this._handleDeleteRequest.bind(this),
            fieldDuplicated: this._handleDuplicateRequest.bind(this)
          };
        }
      }, {
        key: "isActionsEnabled",
        value: function isActionsEnabled() {
          var _this$props = this.props,
              defaultLanguageId = _this$props.defaultLanguageId,
              editingLanguageId = _this$props.editingLanguageId;
          return defaultLanguageId === editingLanguageId;
        }
      }, {
        key: "render",
        value: function render() {
          var spritemap = this.props.spritemap;
          IncrementalDOM.elementOpen("div");
          IncrementalDOM.elementVoid(_clayModal.default, null, null, "body", Liferay.Language.get('are-you-sure-you-want-to-delete-this-field'), "events", {
            clickButton: this._handleDeleteConfirmationModalButtonClicked.bind(this)
          }, "footerButtons", [{
            alignment: 'right',
            label: Liferay.Language.get('dismiss'),
            style: 'primary',
            type: 'close'
          }, {
            alignment: 'right',
            label: Liferay.Language.get('delete'),
            style: 'primary',
            type: 'button'
          }], "spritemap", spritemap, "title", Liferay.Language.get('delete-field-dialog-title'), "ref", "deleteModal", "size", "sm");
          IncrementalDOM.elementOpenStart(ChildComponent);
          iDOMHelpers.forOwn(this.props, iDOMHelpers.attr);
          IncrementalDOM.attr("events", this.getEvents());
          IncrementalDOM.elementOpenEnd(ChildComponent);
          IncrementalDOM.elementClose(ChildComponent);
          iDOMHelpers.renderArbitrary(this.isActionsEnabled() && IncrementalDOM.elementVoid(Actions, null, null, "events", this.getEvents(), "portalElement", this.element, "spritemap", spritemap, "ref", "actions"));
          return IncrementalDOM.elementClose("div");
        }
      }, {
        key: "showDeleteConfirmationModal",
        value: function showDeleteConfirmationModal() {
          var deleteModal = this.refs.deleteModal;
          deleteModal.show();
        }
      }, {
        key: "_handleDeleteConfirmationModalButtonClicked",
        value: function _handleDeleteConfirmationModalButtonClicked(event) {
          var store = this.context.store;
          var target = event.target;
          var deleteModal = this.refs.deleteModal;
          var indexes = this.state.indexes;
          event.stopPropagation();
          deleteModal.emit('hide');

          if (!target.classList.contains('close-modal')) {
            store.emit('fieldDeleted', {
              indexes: indexes
            });
          }
        }
      }, {
        key: "_handleDeleteRequest",
        value: function _handleDeleteRequest(_ref) {
          var indexes = _ref.indexes;
          this.setState({
            indexes: indexes
          });
          this.showDeleteConfirmationModal();
        }
      }, {
        key: "_handleDuplicateRequest",
        value: function _handleDuplicateRequest(indexes) {
          this._handleFieldDuplicated(indexes);
        }
      }, {
        key: "_handleFieldDuplicated",
        value: function _handleFieldDuplicated(indexes) {
          var store = this.context.store;
          store.emit('fieldDuplicated', indexes);
        }
      }, {
        key: "_handleMouseEnterField",
        value: function _handleMouseEnterField(_ref2) {
          var delegateTarget = _ref2.delegateTarget;

          if (this.isActionsEnabled()) {
            _metalDom.default.append(delegateTarget, this.refs.actions.element);
          }
        }
      }]);

      return ActionableFields;
    }(_metalJsx.default);

    _defineProperty(ActionableFields, "STATE", {
      /**
       * @default undefined
       * @instance
       * @memberof ActionableFields
       * @type {?array<string>}
       */
      indexes: _metalState.Config.object()
    });

    _defineProperty(ActionableFields, "PROPS", {
      /**
       * @default
       * @instance
       * @memberof FormBuilder
       * @type {?number}
       */
      activePage: _metalState.Config.number().value(0),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      defaultLanguageId: _metalState.Config.string(),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      editingLanguageId: _metalState.Config.string(),

      /**
       * @default []
       * @instance
       * @memberof Sidebar
       * @type {?(array|undefined)}
       */
      fieldTypes: _metalState.Config.array().value([]),

      /**
       * @default {}
       * @instance
       * @memberof FormBuilder
       * @type {?object}
       */
      focusedField: _config.focusedFieldStructure.value({}),

      /**
       * @default []
       * @instance
       * @memberof FormBuilder
       * @type {?array<object>}
       */
      pages: _metalState.Config.arrayOf(_config.pageStructure).value([]),

      /**
       * @instance
       * @memberof FormBuilder
       * @type {string}
       */
      paginationMode: _metalState.Config.string().required(),

      /**
       * @instance
       * @memberof FormBuilder
       * @type {string}
       */
      rules: _metalState.Config.arrayOf(_config.ruleStructure).required(),

      /**
       * @default undefined
       * @instance
       * @memberof FormRenderer
       * @type {!string}
       */
      spritemap: _metalState.Config.string().required()
    });

    return ActionableFields;
  };

  var _default = withActionableFields;
  exports.default = _default;
  //# sourceMappingURL=withActionableFields.es.js.map
});
//# sourceMappingURL=withActionableFields.es.js.map