/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.form.builder.internal.settings;

import com.liferay.dynamic.data.mapping.form.builder.settings.DDMFormBuilderSettingsRequest;
import com.liferay.dynamic.data.mapping.form.builder.settings.DDMFormBuilderSettingsResponse;
import com.liferay.dynamic.data.mapping.form.builder.settings.DDMFormBuilderSettingsRetriever;
import com.liferay.dynamic.data.mapping.model.DDMForm;

import java.util.Locale;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Rafael Praxedes
 */
@Component(immediate = true, service = DDMFormBuilderSettingsRetriever.class)
public class DDMFormBuilderSettingsRetrieverImpl
	implements DDMFormBuilderSettingsRetriever {

	@Override
	public DDMFormBuilderSettingsResponse getSettings(
		DDMFormBuilderSettingsRequest ddmFormBuilderSettingsRequest) {

		DDMFormBuilderSettingsResponse ddmFormBuilderSettings =
			new DDMFormBuilderSettingsResponse();

		ddmFormBuilderSettings.setDataProviderInstanceParameterSettingsURL(
			_ddmFormBuilderSettingsRetrieverHelper.
				getDDMDataProviderInstanceParameterSettingsURL());

		ddmFormBuilderSettings.setDataProviderInstancesURL(
			_ddmFormBuilderSettingsRetrieverHelper.
				getDDMDataProviderInstancesURL());
		ddmFormBuilderSettings.setFieldSetDefinitionURL(
			_ddmFormBuilderSettingsRetrieverHelper.
				getDDMFieldSetDefinitionURL());
		ddmFormBuilderSettings.setFieldSettingsDDMFormContextURL(
			_ddmFormBuilderSettingsRetrieverHelper.
				getDDMFieldSettingsDDMFormContextURL());
		ddmFormBuilderSettings.setFormContextProviderURL(
			_ddmFormBuilderSettingsRetrieverHelper.
				getDDMFormContextProviderURL());
		ddmFormBuilderSettings.setFunctionsURL(
			_ddmFormBuilderSettingsRetrieverHelper.getDDMFunctionsURL());
		ddmFormBuilderSettings.setRolesURL(
			_ddmFormBuilderSettingsRetrieverHelper.getRolesURL());

		Locale locale = ddmFormBuilderSettingsRequest.getLocale();

		ddmFormBuilderSettings.setFunctionsMetadata(
			_ddmFormBuilderSettingsRetrieverHelper.
				getSerializedDDMExpressionFunctionsMetadata(locale));

		ddmFormBuilderSettings.setFieldSets(
			_ddmFormBuilderSettingsRetrieverHelper.getFieldSetsMetadata(
				ddmFormBuilderSettingsRequest.getCompanyId(),
				ddmFormBuilderSettingsRequest.getScopeGroupId(),
				ddmFormBuilderSettingsRequest.getFieldSetClassNameId(),
				locale));

		DDMForm ddmForm = ddmFormBuilderSettingsRequest.getDDMForm();

		ddmFormBuilderSettings.setSerializedDDMFormRules(
			_ddmFormBuilderSettingsRetrieverHelper.getSerializedDDMFormRules(
				ddmForm));

		return ddmFormBuilderSettings;
	}

	@Reference
	private DDMFormBuilderSettingsRetrieverHelper
		_ddmFormBuilderSettingsRetrieverHelper;

}