/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.form.builder.internal.converter.visitor;

import com.liferay.dynamic.data.mapping.expression.model.Expression;
import com.liferay.dynamic.data.mapping.expression.model.ExpressionVisitor;
import com.liferay.dynamic.data.mapping.expression.model.FloatingPointLiteral;
import com.liferay.dynamic.data.mapping.expression.model.FunctionCallExpression;
import com.liferay.dynamic.data.mapping.expression.model.IntegerLiteral;
import com.liferay.dynamic.data.mapping.expression.model.StringLiteral;
import com.liferay.dynamic.data.mapping.expression.model.Term;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.DDMFormRuleActionFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Rafael Praxedes
 */
public class ActionExpressionVisitor extends ExpressionVisitor<Object> {

	public <T> T doVisit(Expression expression) {
		return (T)expression.accept(this);
	}

	@Override
	public Object visit(FloatingPointLiteral floatingPointLiteral) {
		return floatingPointLiteral.getValue();
	}

	@Override
	public Object visit(FunctionCallExpression functionCallExpression) {
		String action = _functionToActionMap.get(
			functionCallExpression.getFunctionName());

		List<Expression> parameters =
			functionCallExpression.getParameterExpressions();

		return DDMFormRuleActionFactory.create(action, parameters, this);
	}

	@Override
	public Object visit(IntegerLiteral integerLiteral) {
		return integerLiteral.getValue();
	}

	@Override
	public Object visit(StringLiteral stringLiteral) {
		return stringLiteral.getValue();
	}

	@Override
	public Object visit(Term term) {
		return term.getValue();
	}

	private static final Map<String, String> _functionToActionMap =
		new HashMap<>();

	static {
		_functionToActionMap.put("calculate", "calculate");
		_functionToActionMap.put("call", "auto-fill");
		_functionToActionMap.put("jumpPage", "jump-to-page");
		_functionToActionMap.put("setEnabled", "enable");
		_functionToActionMap.put("setInvalid", "invalidate");
		_functionToActionMap.put("setRequired", "require");
		_functionToActionMap.put("setVisible", "show");
	}

}