/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.form.builder.internal.converter.serializer;

import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.action.AutoFillDDMFormRuleAction;
import com.liferay.petra.string.CharPool;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;

import java.util.Map;
import java.util.Map.Entry;

/**
 * @author Leonardo Barros
 */
public class AutoFillDDMFormRuleActionSerializer
	implements DDMFormRuleActionSerializer {

	public AutoFillDDMFormRuleActionSerializer(
		AutoFillDDMFormRuleAction autoFillDDMFormRuleAction) {

		_autoFillDDMFormRuleAction = autoFillDDMFormRuleAction;
	}

	@Override
	public String serialize(
		DDMFormRuleSerializerContext ddmFormRuleSerializerContext) {

		return String.format(
			_FUNCTION_CALL_TERNARY_EXPRESSION_FORMAT, "call",
			StringUtil.quote(
				_autoFillDDMFormRuleAction.getDDMDataProviderInstanceUUID()),
			convertAutoFillInputParameters(
				_autoFillDDMFormRuleAction.getInputParametersMapper()),
			convertAutoFillOutputParameters(
				_autoFillDDMFormRuleAction.getOutputParametersMapper()));
	}

	protected String convertAutoFillInputParameters(
		Map<String, String> inputParametersMapper) {

		if (MapUtil.isEmpty(inputParametersMapper)) {
			return StringUtil.quote(StringPool.BLANK);
		}

		StringBundler sb = new StringBundler(
			inputParametersMapper.size() * 4 - 1);

		for (Entry<String, String> inputParameterMapper :
				inputParametersMapper.entrySet()) {

			sb.append(inputParameterMapper.getKey());
			sb.append(CharPool.EQUAL);
			sb.append(inputParameterMapper.getValue());
			sb.append(CharPool.SEMICOLON);
		}

		sb.setIndex(sb.index() - 1);

		return StringUtil.quote(sb.toString());
	}

	protected String convertAutoFillOutputParameters(
		Map<String, String> outputParametersMapper) {

		if (MapUtil.isEmpty(outputParametersMapper)) {
			return StringUtil.quote(StringPool.BLANK);
		}

		StringBundler sb = new StringBundler(
			outputParametersMapper.size() * 4 - 1);

		for (Entry<String, String> outputParameterMapper :
				outputParametersMapper.entrySet()) {

			sb.append(outputParameterMapper.getValue());
			sb.append(CharPool.EQUAL);
			sb.append(outputParameterMapper.getKey());
			sb.append(CharPool.SEMICOLON);
		}

		sb.setIndex(sb.index() - 1);

		return StringUtil.quote(sb.toString());
	}

	private static final String _FUNCTION_CALL_TERNARY_EXPRESSION_FORMAT =
		"%s(%s, %s, %s)";

	private final AutoFillDDMFormRuleAction _autoFillDDMFormRuleAction;

}