/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.servlet;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"dynamic.data.mapping.form.builder.servlet=true", "osgi.http.whiteboard.context.path=/dynamic-data-mapping-form-builder-functions", "osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMFormFunctionsServlet", "osgi.http.whiteboard.servlet.pattern=/dynamic-data-mapping-form-builder-functions/*"}, service={Servlet.class})
public class DDMFormFunctionsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final Map<String, DDMExpressionFunction> _ddmExpressionFunctions = new ConcurrentHashMap<String, DDMExpressionFunction>();
    @Reference
    private JSONFactory _jsonFactory;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDDMExpressionFunction(DDMExpressionFunction ddmExpressionFunction, Map<String, Object> properties) {
        if (properties.containsKey("ddm.form.evaluator.function.available.on.calculation.rule") && properties.containsKey("ddm.form.evaluator.function.name")) {
            boolean available = MapUtil.getBoolean(properties, (String)"ddm.form.evaluator.function.available.on.calculation.rule");
            if (!available) {
                return;
            }
            String functionName = MapUtil.getString(properties, (String)"ddm.form.evaluator.function.name");
            this._ddmExpressionFunctions.putIfAbsent(functionName, ddmExpressionFunction);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String languageId = ParamUtil.getString((HttpServletRequest)request, (String)"languageId");
        Set<Map.Entry<String, DDMExpressionFunction>> entries = this._ddmExpressionFunctions.entrySet();
        JSONArray jsonArray = this.toJSONArray(entries, LocaleUtil.fromLanguageId((String)languageId));
        response.setContentType("application/json");
        response.setStatus(200);
        ServletResponseUtil.write((HttpServletResponse)response, (String)jsonArray.toJSONString());
    }

    protected void removeDDMExpressionFunction(DDMExpressionFunction ddmExpressionFunction, Map<String, Object> properties) {
        if (properties.containsKey("ddm.form.evaluator.function.name")) {
            String functionName = MapUtil.getString(properties, (String)"ddm.form.evaluator.function.name");
            this._ddmExpressionFunctions.remove(functionName);
        }
    }

    protected JSONArray toJSONArray(Set<Map.Entry<String, DDMExpressionFunction>> entries, Locale locale) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, ((Object)((Object)this)).getClass());
        for (Map.Entry<String, DDMExpressionFunction> entry : entries) {
            jsonArray.put(this.toJSONObject(entry, resourceBundle));
        }
        return jsonArray;
    }

    protected JSONObject toJSONObject(Map.Entry<String, DDMExpressionFunction> entry, ResourceBundle resourceBundle) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        String key = entry.getKey();
        String labelLanguageKey = key + '_' + "function";
        jsonObject.put("label", LanguageUtil.get((ResourceBundle)resourceBundle, (String)labelLanguageKey));
        jsonObject.put("value", key);
        String tooltipLanguageKey = key + '_' + "tooltip";
        jsonObject.put("tooltip", LanguageUtil.get((ResourceBundle)resourceBundle, (String)tooltipLanguageKey));
        return jsonObject;
    }
}

