/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.expression.VariableDependencies;
import com.liferay.dynamic.data.mapping.expression.internal.DDMExpressionEvaluatorVisitor;
import com.liferay.dynamic.data.mapping.expression.internal.DDMExpressionListener;
import com.liferay.dynamic.data.mapping.expression.internal.DDMExpressionModelVisitor;
import com.liferay.dynamic.data.mapping.expression.internal.Variable;
import com.liferay.dynamic.data.mapping.expression.internal.parser.DDMExpressionLexer;
import com.liferay.dynamic.data.mapping.expression.internal.parser.DDMExpressionParser;
import com.liferay.dynamic.data.mapping.expression.model.Expression;
import com.liferay.portal.kernel.util.ListUtil;
import java.math.MathContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class DDMExpressionImpl<T>
implements DDMExpression<T> {
    private final Map<String, DDMExpressionFunction> _ddmExpressionFunctions = new HashMap<String, DDMExpressionFunction>();
    private final Class<?> _expressionClass;
    private final DDMExpressionParser.ExpressionContext _expressionContext;
    private final Set<String> _expressionFunctionNames = new HashSet<String>();
    private Expression _expressionModel;
    private final String _expressionString;
    private final Map<String, Variable> _variables = new TreeMap<String, Variable>();
    private final Map<String, Object> _variableValues = new HashMap<String, Object>();

    public DDMExpressionImpl(String expressionString, Class<T> expressionClass) throws DDMExpressionException {
        if (expressionString == null || expressionString.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this._expressionString = expressionString;
        this._expressionClass = expressionClass;
        this._expressionContext = this.createExpressionContext();
        this.registerExpressionFunctionsAndVariables();
        this.registerExpressionModel();
    }

    public T evaluate() throws DDMExpressionException {
        Set<String> undefinedFunctionNames = this.getUndefinedFunctionNames();
        if (!undefinedFunctionNames.isEmpty()) {
            throw new DDMExpressionException.FunctionNotDefined(undefinedFunctionNames);
        }
        try {
            DDMExpressionEvaluatorVisitor ddmExpressionEvaluatorVisitor = this.createDDMExpressionEvaluatorVisitor();
            Object result = this._expressionContext.accept(ddmExpressionEvaluatorVisitor);
            return (T)this.toRetunType(result);
        }
        catch (DDMExpressionException ddmee) {
            throw ddmee;
        }
        catch (Exception e) {
            throw new DDMExpressionException((Throwable)e);
        }
    }

    public Expression getModel() {
        return this._expressionModel;
    }

    public Map<String, VariableDependencies> getVariableDependenciesMap() throws DDMExpressionException {
        HashMap<String, VariableDependencies> variableDependenciesMap = new HashMap<String, VariableDependencies>();
        List variables = ListUtil.fromCollection(this._variables.values());
        for (Variable variable : variables) {
            this.populateVariableDependenciesMap(variable, variableDependenciesMap);
        }
        return variableDependenciesMap;
    }

    public void setBooleanVariableValue(String variableName, Boolean variableValue) {
        this.setVariableValue(variableName, variableValue);
    }

    public void setDDMExpressionFunction(String functionName, DDMExpressionFunction ddmExpressionFunction) {
        this._ddmExpressionFunctions.put(functionName, ddmExpressionFunction);
    }

    public void setDoubleVariableValue(String variableName, Double variableValue) {
        this.setVariableValue(variableName, variableValue);
    }

    public void setExpressionStringVariableValue(String variableName, String variableValue) {
        Variable variable = this._variables.get(variableName);
        if (variable == null) {
            return;
        }
        variable.setExpressionString(variableValue);
    }

    public void setFloatVariableValue(String variableName, Float variableValue) {
        this.setVariableValue(variableName, variableValue.doubleValue());
    }

    public void setIntegerVariableValue(String variableName, Integer variableValue) {
        this.setVariableValue(variableName, variableValue.doubleValue());
    }

    public void setLongVariableValue(String variableName, Long variableValue) {
        this.setVariableValue(variableName, variableValue.doubleValue());
    }

    @Deprecated
    public void setMathContext(MathContext mathContext) {
    }

    public void setNumberVariableValue(String variableName, Number variableValue) {
        this.setVariableValue(variableName, variableValue.doubleValue());
    }

    public void setObjectVariableValue(String variableName, Object variableValue) {
        Variable variable = this._variables.get(variableName);
        if (variable == null) {
            return;
        }
        variable.setValue(variableValue);
        this._variableValues.put(variableName, variableValue);
    }

    public void setStringVariableValue(String variableName, String variableValue) throws DDMExpressionException {
        this.setVariableValue(variableName, variableValue);
    }

    protected void assertResultTypeClass(Class<?> expectedResultTypeClass, Class<?> resultTypeClass) throws DDMExpressionException {
        if (!expectedResultTypeClass.isAssignableFrom(resultTypeClass)) {
            throw new DDMExpressionException.IncompatipleReturnType();
        }
    }

    protected DDMExpressionEvaluatorVisitor createDDMExpressionEvaluatorVisitor() throws DDMExpressionException {
        DDMExpressionEvaluatorVisitor ddmExpressionEvaluatorVisitor = new DDMExpressionEvaluatorVisitor();
        ddmExpressionEvaluatorVisitor.addFunctions(this._ddmExpressionFunctions);
        for (Map.Entry<String, Variable> entry : this._variables.entrySet()) {
            ddmExpressionEvaluatorVisitor.addVariable(entry.getKey(), this.getVariableValue(entry.getValue()));
        }
        return ddmExpressionEvaluatorVisitor;
    }

    protected DDMExpression<Object> createExpression(String expressionString) throws DDMExpressionException {
        DDMExpressionImpl<Object> ddmExpression = new DDMExpressionImpl<Object>(expressionString, Object.class);
        for (String variableName : ddmExpression.getExpressionVariableNames()) {
            Variable variable = this._variables.get(variableName);
            if (variable == null) continue;
            Object variableValue = this.getVariableValue(variable);
            ddmExpression.setVariableValue(variableName, variableValue);
        }
        return ddmExpression;
    }

    protected DDMExpression<Object> createExpression(Variable variable) throws DDMExpressionException {
        if (variable.getExpressionString() == null) {
            return null;
        }
        DDMExpression<Object> ddmExpression = this.createExpression(variable.getExpressionString());
        return ddmExpression;
    }

    protected DDMExpressionParser.ExpressionContext createExpressionContext() throws DDMExpressionException {
        try {
            ANTLRInputStream charStream = new ANTLRInputStream(this._expressionString);
            DDMExpressionLexer ddmExpressionLexer = new DDMExpressionLexer(charStream);
            DDMExpressionParser ddmExpressionParser = new DDMExpressionParser(new CommonTokenStream(ddmExpressionLexer));
            ddmExpressionParser.setErrorHandler(new BailErrorStrategy());
            return ddmExpressionParser.expression();
        }
        catch (Exception e) {
            throw new DDMExpressionException.InvalidSyntax((Throwable)e);
        }
    }

    protected Set<String> getExpressionFunctionNames() {
        return this._expressionFunctionNames;
    }

    protected Set<String> getExpressionVariableNames() {
        return this._variables.keySet();
    }

    protected Set<String> getUndefinedFunctionNames() {
        HashSet<String> undefinedFunctionNames = new HashSet<String>(this.getExpressionFunctionNames());
        undefinedFunctionNames.removeAll(this._ddmExpressionFunctions.keySet());
        return undefinedFunctionNames;
    }

    protected Object getVariableValue(Variable variable) throws DDMExpressionException {
        Object variableValue = this._variableValues.get(variable.getName());
        if (variableValue != null) {
            return variableValue;
        }
        DDMExpression<Object> ddmExpression = this.createExpression(variable);
        variableValue = ddmExpression.evaluate();
        this._variableValues.put(variable.getName(), variableValue);
        return variableValue;
    }

    protected VariableDependencies populateVariableDependenciesMap(Variable variable, Map<String, VariableDependencies> variableDependenciesMap) throws DDMExpressionException {
        VariableDependencies variableDependencies = variableDependenciesMap.get(variable.getName());
        if (variableDependencies != null) {
            return variableDependencies;
        }
        variableDependencies = new VariableDependencies(variable.getName());
        if (variable.getExpressionString() != null) {
            DDMExpressionImpl<Object> ddmExpression = new DDMExpressionImpl<Object>(variable.getExpressionString(), Object.class);
            for (String variableName : ddmExpression.getExpressionVariableNames()) {
                if (!this._variables.containsKey(variableName)) {
                    Variable newVariable = new Variable(variableName);
                    this._variables.put(variableName, newVariable);
                }
                VariableDependencies variableVariableDependencies = this.populateVariableDependenciesMap(this._variables.get(variableName), variableDependenciesMap);
                variableVariableDependencies.addAffectedVariable(variableDependencies.getVariableName());
                variableDependencies.addRequiredVariable(variableVariableDependencies.getVariableName());
            }
        }
        variableDependenciesMap.put(variable.getName(), variableDependencies);
        return variableDependencies;
    }

    protected void registerExpressionFunctionsAndVariables() {
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        DDMExpressionListener ddmExpressionListener = new DDMExpressionListener();
        parseTreeWalker.walk(ddmExpressionListener, this._expressionContext);
        this._expressionFunctionNames.addAll(ddmExpressionListener.getFunctionNames());
        for (String variableName : ddmExpressionListener.getVariableNames()) {
            this._variables.put(variableName, new Variable(variableName));
        }
    }

    protected void registerExpressionModel() {
        DDMExpressionModelVisitor ddmExpressionModelVisitor = new DDMExpressionModelVisitor();
        this._expressionModel = this._expressionContext.accept(ddmExpressionModelVisitor);
    }

    protected void setVariableValue(String variableName, Object variableValue) {
        Variable variable = this._variables.get(variableName);
        if (variable == null) {
            return;
        }
        variable.setValue(variableValue);
        this._variableValues.put(variableName, variableValue);
    }

    protected double toDouble(Object result) throws DDMExpressionException {
        Number number = (Number)result;
        return number.doubleValue();
    }

    protected float toFloat(Object result) throws DDMExpressionException {
        Number number = (Number)result;
        return number.floatValue();
    }

    protected int toInteger(Object result) throws DDMExpressionException {
        Number number = (Number)result;
        return number.intValue();
    }

    protected long toLong(Object result) throws DDMExpressionException {
        Number number = (Number)result;
        return number.longValue();
    }

    protected Object toRetunType(Object result) throws DDMExpressionException {
        if (String.class.isAssignableFrom(this._expressionClass)) {
            return String.valueOf(result);
        }
        if (Boolean.class.isAssignableFrom(this._expressionClass)) {
            this.assertResultTypeClass(Boolean.class, result.getClass());
            return result;
        }
        if (Double.class.isAssignableFrom(this._expressionClass)) {
            this.assertResultTypeClass(Number.class, result.getClass());
            return this.toDouble(result);
        }
        if (Float.class.isAssignableFrom(this._expressionClass)) {
            this.assertResultTypeClass(Number.class, result.getClass());
            return Float.valueOf(this.toFloat(result));
        }
        if (Integer.class.isAssignableFrom(this._expressionClass)) {
            this.assertResultTypeClass(Number.class, result.getClass());
            return this.toInteger(result);
        }
        if (Long.class.isAssignableFrom(this._expressionClass)) {
            this.assertResultTypeClass(Number.class, result.getClass());
            return this.toLong(result);
        }
        if (Number.class.isAssignableFrom(this._expressionClass)) {
            this.assertResultTypeClass(Number.class, result.getClass());
            return result;
        }
        return result;
    }
}

