/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.demo.data.creator.internal;

import com.liferay.dynamic.data.mapping.demo.data.creator.DDMStructureDemoDataCreator;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMStructureDemoDataCreator.class})
public class DDMStructureDemoDataCreatorImpl
implements DDMStructureDemoDataCreator {
    @Reference
    private DDM _ddm;
    @Reference(target="(ddm.form.deserializer.type=xsd)")
    private DDMFormDeserializer _ddmFormDeserializer;
    private final List<Long> _ddmStructureIds = new CopyOnWriteArrayList<Long>();
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private Portal _portal;

    public DDMStructure create(long groupId, long userId) throws PortalException {
        String definition = StringUtil.read(DDMStructureDemoDataCreatorImpl.class, (String)"dependencies/test-structure.xsd");
        DDMForm ddmForm = this._toDDMForm(definition);
        DDMFormLayout ddmFormLayout = this._ddm.getDefaultDDMFormLayout(ddmForm);
        DDMStructure ddmStructure = this._ddmStructureLocalService.addStructure(userId, groupId, 0L, this._portal.getClassNameId(DDMFormInstance.class.getName()), null, (Map)HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)"Test Structure").build(), null, ddmForm, ddmFormLayout, StorageType.JSON.getValue(), 0, new ServiceContext());
        this._ddmStructureIds.add(ddmStructure.getStructureId());
        return ddmStructure;
    }

    public void delete() throws PortalException {
        for (Long ddmStructureId : this._ddmStructureIds) {
            this._ddmStructureIds.remove(ddmStructureId);
            this._ddmStructureLocalService.deleteStructure(ddmStructureId.longValue());
        }
    }

    private DDMForm _toDDMForm(String definition) {
        DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)definition);
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = this._ddmFormDeserializer.deserialize(builder.build());
        return ddmFormDeserializerDeserializeResponse.getDDMForm();
    }
}

