/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.demo.data.creator.internal;

import com.liferay.dynamic.data.mapping.demo.data.creator.DDMFormInstanceRecordDemoDataCreator;
import com.liferay.dynamic.data.mapping.demo.data.creator.DDMStructureDemoDataCreator;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMFormInstanceRecordDemoDataCreator.class})
public class DDMFormInstanceRecordDemoDataCreatorImpl
implements DDMFormInstanceRecordDemoDataCreator {
    @Reference
    private DDMFormInstanceLocalService _ddmFormInstanceLocalService;
    private final List<Long> _ddmFormInstanceRecordIds = new CopyOnWriteArrayList<Long>();
    @Reference
    private DDMFormInstanceRecordLocalService _ddmFormInstanceRecordLocalService;
    @Reference
    private DDMStructureDemoDataCreator _ddmStructureDemoDataCreator;

    public DDMFormInstanceRecord create(long userId, long groupId, Date createDate, long ddmFormInstanceId) throws PortalException {
        DDMFormInstance ddmFormInstance = this._ddmFormInstanceLocalService.getDDMFormInstance(ddmFormInstanceId);
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        final DDMForm ddmForm = ddmStructure.getDDMForm();
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm){
            {
                super(x0);
                this.setAvailableLocales(ddmForm.getAvailableLocales());
                this.setDefaultLocale(ddmForm.getDefaultLocale());
            }
        };
        for (final DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            if (ddmFormField.isLocalizable()) {
                ddmFormValues.addDDMFormFieldValue(new DDMFormFieldValue(){
                    {
                        this.setInstanceId(StringUtil.randomString());
                        this.setName(ddmFormField.getName());
                        this.setValue((Value)new LocalizedValue(LocaleUtil.US){
                            {
                                this.addString(LocaleUtil.US, StringUtil.randomString());
                            }
                        });
                    }
                });
                continue;
            }
            ddmFormValues.addDDMFormFieldValue(new DDMFormFieldValue(){
                {
                    this.setInstanceId(StringUtil.randomString());
                    this.setName(ddmFormField.getName());
                    this.setValue((Value)new UnlocalizedValue(StringUtil.randomString()));
                }
            });
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setUserId(userId);
        DDMFormInstanceRecord ddmFormInstanceRecord = this._ddmFormInstanceRecordLocalService.addFormInstanceRecord(userId, groupId, ddmFormInstanceId, ddmFormValues, serviceContext);
        if (createDate != null) {
            ddmFormInstanceRecord.setCreateDate(createDate);
            ddmFormInstanceRecord = this._ddmFormInstanceRecordLocalService.updateDDMFormInstanceRecord(ddmFormInstanceRecord);
        }
        this._ddmFormInstanceRecordIds.add(ddmFormInstanceRecord.getFormInstanceRecordId());
        return ddmFormInstanceRecord;
    }

    public void delete() throws PortalException {
        for (Long ddmFormInstanceRecordId : this._ddmFormInstanceRecordIds) {
            this._ddmFormInstanceRecordIds.remove(ddmFormInstanceRecordId);
            this._ddmFormInstanceRecordLocalService.deleteFormInstanceRecord(ddmFormInstanceRecordId.longValue());
        }
        this._ddmStructureDemoDataCreator.delete();
    }
}

