/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.instance.internal;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.Portal;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.data.provider.instance.id=getDataProviderInstances"}, service={DDMDataProvider.class})
public class DDMDataProviderInstancesDataProvider
implements DDMDataProvider {
    @Reference
    protected DDMDataProviderInstanceLocalService ddmDataProviderInstanceLocalService;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(DDMDataProviderInstancesDataProvider.class);

    public DDMDataProviderResponse getData(DDMDataProviderRequest ddmDataProviderRequest) {
        ArrayList<KeyValuePair> keyValuePairs;
        block3: {
            keyValuePairs = new ArrayList<KeyValuePair>();
            try {
                long[] groupIds = this.portal.getCurrentAndAncestorSiteGroupIds(ddmDataProviderRequest.getGroupId());
                List ddmDataProviderInstances = this.ddmDataProviderInstanceLocalService.getDataProviderInstances(groupIds);
                for (DDMDataProviderInstance ddmDataProviderInstance : ddmDataProviderInstances) {
                    long value = ddmDataProviderInstance.getDataProviderInstanceId();
                    String label = ddmDataProviderInstance.getName(LocaleThreadLocal.getThemeDisplayLocale());
                    keyValuePairs.add(new KeyValuePair(String.valueOf(value), label));
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
        DDMDataProviderResponse.Builder builder = DDMDataProviderResponse.Builder.newBuilder();
        return builder.withOutput("Default-Output", keyValuePairs).build();
    }

    public Class<?> getSettings() {
        throw new UnsupportedOperationException();
    }
}

