/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.exporter;

import com.liferay.dynamic.data.lists.exporter.DDLExporter;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSetVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordSetVersionService;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldValueRendererRegistry;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public abstract class BaseDDLExporter
implements DDLExporter {
    private Locale _locale;

    public byte[] export(long recordSetId) throws Exception {
        return this.doExport(recordSetId, -1, -1, -1, null);
    }

    public byte[] export(long recordSetId, int status) throws Exception {
        return this.doExport(recordSetId, status, -1, -1, null);
    }

    public byte[] export(long recordSetId, int status, int start, int end) throws Exception {
        return this.doExport(recordSetId, status, start, end, null);
    }

    public byte[] export(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) throws Exception {
        return this.doExport(recordSetId, status, start, end, orderByComparator);
    }

    public Locale getLocale() {
        if (this._locale == null) {
            this._locale = LocaleUtil.getSiteDefault();
        }
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    protected abstract byte[] doExport(long var1, int var3, int var4, int var5, OrderByComparator<DDLRecord> var6) throws Exception;

    protected String formatDate(Date date, DateTimeFormatter dateTimeFormatter) {
        return dateTimeFormatter.format(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
    }

    protected DateTimeFormatter getDateTimeFormatter() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT);
        return dateTimeFormatter.withLocale(this.getLocale());
    }

    protected abstract DDLRecordSetVersionService getDDLRecordSetVersionService();

    protected abstract DDMFormFieldTypeServicesRegistry getDDMFormFieldTypeServicesRegistry();

    protected abstract DDMFormFieldValueRendererRegistry getDDMFormFieldValueRendererRegistry();

    protected Map<String, DDMFormField> getDistinctFields(long recordSetId) throws Exception {
        LinkedHashMap<String, DDMFormField> ddmFormFields = new LinkedHashMap<String, DDMFormField>();
        DDLRecordSetVersionService ddlRecordSetVersionService = this.getDDLRecordSetVersionService();
        for (DDMStructureVersion ddmStructureVersion : TransformUtil.transform((Collection)ddlRecordSetVersionService.getRecordSetVersions(recordSetId, -1, -1, null), DDLRecordSetVersion::getDDMStructureVersion)) {
            DDMForm ddmForm = ddmStructureVersion.getDDMForm();
            ddmFormFields.putAll(ddmForm.getDDMFormFieldsMap(true));
        }
        return ddmFormFields;
    }

    protected Map<String, DDMFormFieldRenderedValue> getRenderedValues(int scope, Collection<DDMFormField> ddmFormFields, DDMFormValues ddmFormValues, HtmlParser htmlParser) throws Exception {
        HashMap<String, DDMFormFieldRenderedValue> values = new HashMap<String, DDMFormFieldRenderedValue>();
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap(false);
        for (DDMFormField ddmFormField : ddmFormFields) {
            if (!ddmFormFieldValuesMap.containsKey(ddmFormField.getName())) continue;
            DDMFormFieldRenderedValue ddmFormFieldRenderedValue = this._getDDMFormFieldRenderedValue(scope, ddmFormField, ddmFormFieldValuesMap, htmlParser);
            values.put(ddmFormFieldRenderedValue.getFieldName(), ddmFormFieldRenderedValue);
        }
        return values;
    }

    protected String getStatusMessage(int status) {
        return LanguageUtil.get((Locale)this._locale, (String)WorkflowConstants.getStatusLabel((int)status));
    }

    private DDMFormFieldRenderedValue _getDDMFormFieldRenderedValue(int scope, DDMFormField ddmFormField, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, HtmlParser htmlParser) {
        List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValuesMap.get(ddmFormField.getName());
        String valueString = "";
        DDMFormFieldValue ddmFormFieldValue = ddmFormFieldValues.get(0);
        if (scope == 2) {
            DDMFormFieldValueRenderer ddmFormFieldValueRenderer = this.getDDMFormFieldTypeServicesRegistry().getDDMFormFieldValueRenderer(ddmFormFieldValue.getType());
            valueString = ddmFormFieldValueRenderer.render(ddmFormFieldValue, this.getLocale());
        } else {
            DDMFormFieldValueRendererRegistry ddmFormFieldValueRendererRegistry = this.getDDMFormFieldValueRendererRegistry();
            com.liferay.dynamic.data.mapping.render.DDMFormFieldValueRenderer ddmFormFieldValueRenderer = ddmFormFieldValueRendererRegistry.getDDMFormFieldValueRenderer(ddmFormField.getType());
            if (Objects.equals("ddm-text-html", ddmFormFieldValueRenderer.getSupportedDDMFormFieldType())) {
                Value value = ddmFormFieldValue.getValue();
                valueString = HtmlUtil.escape((String)value.getString(this.getLocale()));
            } else {
                valueString = ddmFormFieldValueRenderer.render(ddmFormFieldValues, this.getLocale());
            }
        }
        valueString = htmlParser.render(valueString);
        return new DDMFormFieldRenderedValue(ddmFormField.getName(), ddmFormField.getLabel(), valueString);
    }

    protected static class DDMFormFieldRenderedValue {
        private final String _fieldName;
        private final LocalizedValue _label;
        private final String _value;

        protected DDMFormFieldRenderedValue(String fieldName, LocalizedValue label, String value) {
            this._fieldName = fieldName;
            this._label = label;
            this._value = value;
        }

        protected String getFieldName() {
            return this._fieldName;
        }

        protected LocalizedValue getLabel() {
            return this._label;
        }

        protected String getValue() {
            return this._value;
        }
    }
}

