/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.exporter;

import com.liferay.dynamic.data.lists.exporter.DDLExporter;
import com.liferay.dynamic.data.lists.internal.exporter.BaseDDLExporter;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetVersionService;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldValueRendererRegistry;
import com.liferay.dynamic.data.mapping.storage.DDMStorageEngineManager;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDLExporter.class})
public class DDLXLSExporter
extends BaseDDLExporter {
    private static final Log _log = LogFactoryUtil.getLog(DDLXLSExporter.class);
    @Reference
    private DDLRecordLocalService _ddlRecordLocalService;
    @Reference
    private DDLRecordSetService _ddlRecordSetService;
    @Reference
    private DDLRecordSetVersionService _ddlRecordSetVersionService;
    @Reference
    private DDMFormFieldTypeServicesRegistry _ddmFormFieldTypeServicesRegistry;
    @Reference
    private DDMFormFieldValueRendererRegistry _ddmFormFieldValueRendererRegistry;
    @Reference
    private DDMStorageEngineManager _ddmStorageEngineManager;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private Language _language;

    public String getFormat() {
        return "xls";
    }

    /*
     * Exception decompiling
     */
    @Override
    protected byte[] doExport(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected DDLRecordSetVersionService getDDLRecordSetVersionService() {
        return this._ddlRecordSetVersionService;
    }

    @Override
    protected DDMFormFieldTypeServicesRegistry getDDMFormFieldTypeServicesRegistry() {
        return this._ddmFormFieldTypeServicesRegistry;
    }

    @Override
    protected DDMFormFieldValueRendererRegistry getDDMFormFieldValueRendererRegistry() {
        return this._ddmFormFieldValueRendererRegistry;
    }

    private CellStyle _createCellStyle(Workbook workbook, boolean bold, String fontName, short heightInPoints) {
        Font font = workbook.createFont();
        font.setBold(bold);
        font.setFontHeightInPoints(heightInPoints);
        font.setFontName(fontName);
        CellStyle style = workbook.createCellStyle();
        style.setFont(font);
        return style;
    }

    private void _createDataRow(int rowIndex, Sheet sheet, DateTimeFormatter dateTimeFormatter, String author, String status, Date statusDate, CellStyle style, Map<String, DDMFormField> ddmFormFields, Map<String, BaseDDLExporter.DDMFormFieldRenderedValue> values) {
        Cell cell;
        Row row = sheet.createRow(rowIndex);
        int cellIndex = 0;
        for (Map.Entry<String, DDMFormField> entry : ddmFormFields.entrySet()) {
            cell = row.createCell(cellIndex++, CellType.STRING);
            cell.setCellStyle(style);
            if (values.containsKey(entry.getKey())) {
                BaseDDLExporter.DDMFormFieldRenderedValue ddmFormFieldRenderedValue = values.get(entry.getKey());
                cell.setCellValue(GetterUtil.getString((String)ddmFormFieldRenderedValue.getValue()));
                continue;
            }
            cell.setCellValue("");
        }
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(style);
        cell.setCellValue(status);
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(style);
        cell.setCellValue(this.formatDate(statusDate, dateTimeFormatter));
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(style);
        cell.setCellValue(author);
    }

    private void _createHeaderRow(Collection<DDMFormField> ddmFormFields, Sheet sheet, Workbook workbook) {
        Cell cell;
        Row row = sheet.createRow(0);
        CellStyle cellStyle = this._createCellStyle(workbook, true, "Courier New", (short)14);
        int cellIndex = 0;
        Locale locale = this.getLocale();
        for (DDMFormField ddmFormField : ddmFormFields) {
            LocalizedValue label = ddmFormField.getLabel();
            cell = row.createCell(cellIndex++, CellType.STRING);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(label.getString(locale));
        }
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(this._language.get(locale, "status"));
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(this._language.get(locale, "modified-date"));
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(this._language.get(locale, "author"));
    }
}

