/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.exportimport.staged.model.repository;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.osgi.util.service.Snapshot;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.Objects;

public class DDLRecordStagedModelRepositoryUtil {
    private static final Snapshot<DDLRecordLocalService> _ddlRecordLocalServiceSnapshot = new Snapshot(DDLRecordStagedModelRepositoryUtil.class, DDLRecordLocalService.class);
    private static final Snapshot<DDLRecordVersionLocalService> _ddlRecordVersionLocalServiceSnapshot = new Snapshot(DDLRecordStagedModelRepositoryUtil.class, DDLRecordVersionLocalService.class);

    public static DDLRecord addStagedModel(PortletDataContext portletDataContext, DDLRecord ddlRecord, DDMFormValues ddmFormValues) throws PortalException {
        long userId = portletDataContext.getUserId(ddlRecord.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ddlRecord);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(ddlRecord.getUuid());
        }
        DDLRecordLocalService ddlRecordLocalService = (DDLRecordLocalService)_ddlRecordLocalServiceSnapshot.get();
        DDLRecord importedRecord = ddlRecordLocalService.addRecord(userId, ddlRecord.getGroupId(), ddlRecord.getRecordSetId(), ddlRecord.getDisplayIndex(), ddmFormValues, serviceContext);
        DDLRecordStagedModelRepositoryUtil._updateVersions(importedRecord, ddlRecord.getVersion());
        return importedRecord;
    }

    public static DDLRecord updateStagedModel(PortletDataContext portletDataContext, DDLRecord ddlRecord, DDMFormValues ddmFormValues) throws PortalException {
        long userId = portletDataContext.getUserId(ddlRecord.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ddlRecord);
        DDLRecordLocalService ddlRecordLocalService = (DDLRecordLocalService)_ddlRecordLocalServiceSnapshot.get();
        DDLRecord importedRecord = ddlRecordLocalService.updateRecord(userId, ddlRecord.getRecordId(), false, ddlRecord.getDisplayIndex(), ddmFormValues, serviceContext);
        DDLRecordStagedModelRepositoryUtil._updateVersions(importedRecord, ddlRecord.getVersion());
        return importedRecord;
    }

    private static void _updateVersions(DDLRecord importedRecord, String version) throws PortalException {
        if (Objects.equals(importedRecord.getVersion(), version)) {
            return;
        }
        DDLRecordVersion importedRecordVersion = importedRecord.getRecordVersion();
        importedRecordVersion.setVersion(version);
        DDLRecordVersionLocalService ddlRecordVersionLocalService = (DDLRecordVersionLocalService)_ddlRecordVersionLocalServiceSnapshot.get();
        ddlRecordVersionLocalService.updateDDLRecordVersion(importedRecordVersion);
        importedRecord.setVersion(version);
        DDLRecordLocalService ddlRecordLocalService = (DDLRecordLocalService)_ddlRecordLocalServiceSnapshot.get();
        ddlRecordLocalService.updateDDLRecord(importedRecord);
    }
}

