/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.search.spi.model.result.contributor;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.search.spi.model.result.contributor.ModelSummaryContributor;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.dynamic.data.lists.model.DDLRecord"}, service={ModelSummaryContributor.class})
public class DDLRecordModelSummaryContributor
implements ModelSummaryContributor {
    @Reference
    protected DDLRecordSetLocalService ddlRecordSetLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DDLRecordModelSummaryContributor.class);

    public Summary getSummary(Document document, Locale locale, String snippet) {
        Summary summary = new Summary(this.getTitle(GetterUtil.getLong((String)document.get("recordSetId")), locale), document.get(locale, StringBundler.concat((String[])new String[]{"snippet", "_", "description"}), "description"));
        summary.setMaxContentLength(200);
        return summary;
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        return resourceBundleLoader.loadResourceBundle(locale);
    }

    protected String getTitle(long ddlRecordSetId, Locale locale) {
        try {
            DDLRecordSet ddlRecordSet = this.ddlRecordSetLocalService.getRecordSet(ddlRecordSetId);
            String recordSetName = ddlRecordSet.getName(locale);
            return LanguageUtil.format((ResourceBundle)this.getResourceBundle(locale), (String)this._getLanguageKey(ddlRecordSet), (Object)recordSetName, (boolean)false);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return "";
        }
    }

    private String _getLanguageKey(DDLRecordSet ddlRecordSet) {
        if (ddlRecordSet.getScope() == 0) {
            return "record-for-list-x";
        }
        return "form-record-for-form-x";
    }
}

