/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.search.spi.model.index.contributor;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.dynamic.data.lists.model.DDLRecordSet"}, service={ModelDocumentContributor.class})
public class DDLRecordSetModelDocumentContributor
implements ModelDocumentContributor<DDLRecordSet> {
    @Reference
    protected ClassNameLocalService classNameLocalService;

    public void contribute(Document document, DDLRecordSet ddlRecordSet) {
        String[] nameLanguageIds;
        String[] descriptionLanguageIds;
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        for (String descriptionLanguageId : descriptionLanguageIds = this.getLanguageIds(defaultLanguageId, ddlRecordSet.getDescription())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"description", (String)descriptionLanguageId), ddlRecordSet.getDescription(descriptionLanguageId));
        }
        for (String nameLanguageId : nameLanguageIds = this.getLanguageIds(defaultLanguageId, ddlRecordSet.getName())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"name", (String)nameLanguageId), ddlRecordSet.getName(nameLanguageId));
        }
        document.addKeyword("version", ddlRecordSet.getVersion());
        document.addKeyword("DDMStructureId", ddlRecordSet.getDDMStructureId());
        document.addKeyword("scope", ddlRecordSet.getScope());
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = LocalizationUtil.getAvailableLanguageIds((String)content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

