/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.exportimport.data.handler;

import com.liferay.dynamic.data.lists.internal.exportimport.staged.model.repository.DDLRecordStagedModelRepository;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerTracker;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerTracker;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class DDLRecordStagedModelDataHandler
extends BaseStagedModelDataHandler<DDLRecord> {
    public static final String[] CLASS_NAMES = new String[]{DDLRecord.class.getName()};
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    private DDLRecordStagedModelRepository _ddlRecordStagedModelRepository;
    private DDMFormValuesDeserializerTracker _ddmFormValuesDeserializerTracker;
    private ExportImportContentProcessor<DDMFormValues> _ddmFormValuesExportImportContentProcessor;
    private DDMFormValuesSerializerTracker _ddmFormValuesSerializerTracker;
    private StorageEngine _storageEngine;

    @Deprecated
    public void deleteStagedModel(DDLRecord stagedModel) throws PortalException {
        super.deleteStagedModel((StagedModel)stagedModel);
    }

    @Deprecated
    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        super.deleteStagedModel(uuid, groupId, className, extraData);
    }

    @Deprecated
    public DDLRecord fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return (DDLRecord)super.fetchStagedModelByUuidAndGroupId(uuid, groupId);
    }

    @Deprecated
    public List<DDLRecord> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return super.fetchStagedModelsByUuidAndCompanyId(uuid, companyId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDLRecord record) {
        return record.getUuid();
    }

    protected DDMFormValues deserialize(String content, DDMForm ddmForm) {
        DDMFormValuesDeserializer ddmFormValuesDeserializer = this._ddmFormValuesDeserializerTracker.getDDMFormValuesDeserializer("json");
        DDMFormValuesDeserializerDeserializeRequest.Builder builder = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)content, (DDMForm)ddmForm);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = ddmFormValuesDeserializer.deserialize(builder.build());
        return ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDLRecord record) throws Exception {
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)record, (StagedModel)record.getRecordSet(), (String)"strong");
        Element recordElement = portletDataContext.getExportDataElement((ClassedModel)record);
        this.exportDDMFormValues(portletDataContext, record, recordElement);
        portletDataContext.addClassedModel(recordElement, ExportImportPathUtil.getModelPath((StagedModel)record), (ClassedModel)record);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long recordId) throws Exception {
        DDLRecord existingRecord = (DDLRecord)this.fetchMissingReference(uuid, groupId);
        Map recordIds = portletDataContext.getNewPrimaryKeysMap(DDLRecord.class);
        recordIds.put(recordId, existingRecord.getRecordId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDLRecord record) throws Exception {
        Map recordSetIds = portletDataContext.getNewPrimaryKeysMap(DDLRecordSet.class);
        long recordSetId = MapUtil.getLong((Map)recordSetIds, (long)record.getRecordSetId(), (long)record.getRecordSetId());
        Element recordElement = portletDataContext.getImportDataElement((StagedModel)record);
        DDMFormValues ddmFormValues = this.getImportDDMFormValues(portletDataContext, recordElement, recordSetId);
        DDLRecord importedRecord = (DDLRecord)record.clone();
        importedRecord.setGroupId(portletDataContext.getScopeGroupId());
        importedRecord.setRecordSetId(recordSetId);
        DDLRecord existingRecord = this._ddlRecordStagedModelRepository.fetchStagedModelByUuidAndGroupId(record.getUuid(), portletDataContext.getScopeGroupId());
        if (existingRecord == null || !portletDataContext.isDataStrategyMirror()) {
            importedRecord = this._ddlRecordStagedModelRepository.addStagedModel(portletDataContext, importedRecord, ddmFormValues);
        } else {
            importedRecord.setRecordId(existingRecord.getRecordId());
            importedRecord = this._ddlRecordStagedModelRepository.updateStagedModel(portletDataContext, importedRecord, ddmFormValues);
        }
        portletDataContext.importClassedModel((ClassedModel)record, (ClassedModel)importedRecord);
    }

    protected void exportDDMFormValues(PortletDataContext portletDataContext, DDLRecord record, Element recordElement) throws Exception {
        String ddmFormValuesPath = ExportImportPathUtil.getModelPath((StagedModel)record, (String)"ddm-form-values.json");
        recordElement.addAttribute("ddm-form-values-path", ddmFormValuesPath);
        DDMFormValues ddmFormValues = this._storageEngine.getDDMFormValues(record.getDDMStorageId());
        ddmFormValues = (DDMFormValues)this._ddmFormValuesExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)record, (Serializable)ddmFormValues, true, false);
        portletDataContext.addZipEntry(ddmFormValuesPath, this.serialize(ddmFormValues));
    }

    protected DDMFormValues getImportDDMFormValues(PortletDataContext portletDataContext, Element recordElement, long recordSetId) throws Exception {
        DDLRecordSet recordSet = this._ddlRecordSetLocalService.getRecordSet(recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        String ddmFormValuesPath = recordElement.attributeValue("ddm-form-values-path");
        String serializedDDMFormValues = portletDataContext.getZipEntryAsString(ddmFormValuesPath);
        DDMFormValues ddmFormValues = this.deserialize(serializedDDMFormValues, ddmStructure.getDDMForm());
        return (DDMFormValues)this._ddmFormValuesExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)ddmStructure, (Serializable)ddmFormValues);
    }

    protected StagedModelRepository<DDLRecord> getStagedModelRepository() {
        return this._ddlRecordStagedModelRepository;
    }

    protected String serialize(DDMFormValues ddmFormValues) {
        DDMFormValuesSerializer ddmFormValuesSerializer = this._ddmFormValuesSerializerTracker.getDDMFormValuesSerializer("json");
        DDMFormValuesSerializerSerializeRequest.Builder builder = DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)ddmFormValues);
        DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = ddmFormValuesSerializer.serialize(builder.build());
        return ddmFormValuesSerializerSerializeResponse.getContent();
    }

    @Deprecated
    protected void setDDLRecordLocalService(DDLRecordLocalService ddlRecordLocalService) {
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetLocalService(DDLRecordSetLocalService ddlRecordSetLocalService) {
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
    }

    @Reference(target="(model.class.name=com.liferay.dynamic.data.lists.model.DDLRecord)", unbind="-")
    protected void setDDLRecordStagedModelRepository(DDLRecordStagedModelRepository ddlRecordStagedModelRepository) {
        this._ddlRecordStagedModelRepository = ddlRecordStagedModelRepository;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesDeserializerTracker(DDMFormValuesDeserializerTracker ddmFormValuesDeserializerTracker) {
        this._ddmFormValuesDeserializerTracker = ddmFormValuesDeserializerTracker;
    }

    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.storage.DDMFormValues)", unbind="-")
    protected void setDDMFormValuesExportImportContentProcessor(ExportImportContentProcessor<DDMFormValues> ddmFormValuesExportImportContentProcessor) {
        this._ddmFormValuesExportImportContentProcessor = ddmFormValuesExportImportContentProcessor;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesSerializerTracker(DDMFormValuesSerializerTracker ddmFormValuesSerializerTracker) {
        this._ddmFormValuesSerializerTracker = ddmFormValuesSerializerTracker;
    }

    @Reference(unbind="-")
    protected void setStorageEngine(StorageEngine storageEngine) {
        this._storageEngine = storageEngine;
    }

    protected void validateExport(PortletDataContext portletDataContext, DDLRecord record) throws PortletDataException {
        int status = -1;
        try {
            status = record.getStatus();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
        if (!portletDataContext.isInitialPublication() && !ArrayUtil.contains((int[])this.getExportableStatuses(), (int)status)) {
            PortletDataException pde = new PortletDataException(9);
            pde.setStagedModelDisplayName(record.getUuid());
            pde.setStagedModelClassName(record.getModelClassName());
            pde.setStagedModelClassPK(GetterUtil.getString((Object)record.getRecordId()));
            throw pde;
        }
    }
}

