/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.impl;

import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.lists.exception.NoSuchRecordException;
import com.liferay.dynamic.data.lists.exception.RecordGroupIdException;
import com.liferay.dynamic.data.lists.model.DDLFormRecord;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordConstants;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordVersionLocalService;
import com.liferay.dynamic.data.lists.service.base.DDLRecordLocalServiceBaseImpl;
import com.liferay.dynamic.data.lists.util.DDL;
import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.lists.model.DDLRecord"}, service={AopService.class})
public class DDLRecordLocalServiceImpl
extends DDLRecordLocalServiceBaseImpl {
    @Reference
    protected DDM ddm;
    @Reference
    protected DDMFormValuesToFieldsConverter ddmFormValuesToFieldsConverter;
    @Reference
    protected DDMStructureLocalService ddmStructureLocalService;
    @Reference
    protected FieldsToDDMFormValuesConverter fieldsToDDMFormValuesConverter;
    @Reference
    protected IndexerRegistry indexerRegistry;
    @Reference
    protected StorageEngine storageEngine;
    private static final String _FIELDS_DISPLAY_NAME = "_fieldsDisplay";
    private static final String _INSTANCE_SEPARATOR = "_INSTANCE_";
    private static final Log _log = LogFactoryUtil.getLog(DDLRecordLocalServiceImpl.class);
    @Reference
    private DDLRecordVersionLocalService _ddlRecordVersionLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public DDLRecord addRecord(long userId, long groupId, long recordSetId, int displayIndex, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        this.validate(groupId, recordSet);
        long recordId = this.counterLocalService.increment();
        DDLRecord record = this.ddlRecordPersistence.create(recordId);
        record.setUuid(serviceContext.getUuid());
        record.setGroupId(groupId);
        record.setCompanyId(user.getCompanyId());
        record.setUserId(user.getUserId());
        record.setUserName(user.getFullName());
        record.setVersionUserId(user.getUserId());
        record.setVersionUserName(user.getFullName());
        long ddmStorageId = this.storageEngine.create(recordSet.getCompanyId(), recordSet.getDDMStructureId(), ddmFormValues, serviceContext);
        record.setDDMStorageId(ddmStorageId);
        record.setRecordSetId(recordSetId);
        record.setRecordSetVersion(recordSet.getVersion());
        record.setVersion("1.0");
        record.setDisplayIndex(displayIndex);
        this.ddlRecordPersistence.update((BaseModel)record);
        int status = GetterUtil.getInteger((Object)serviceContext.getAttribute("status"), (int)2);
        DDLRecordVersion recordVersion = this.addRecordVersion(user, record, ddmStorageId, "1.0", displayIndex, status);
        this.updateAsset(userId, record, recordVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getLocale(), serviceContext.getAssetPriority());
        if (serviceContext.getWorkflowAction() == 1) {
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)this.getWorkflowAssetClassName(recordSet), (long)recordVersion.getRecordVersionId(), (Object)recordVersion, (ServiceContext)serviceContext);
        }
        return record;
    }

    @Deprecated
    public DDLRecord addRecord(long userId, long groupId, long recordSetId, int displayIndex, Fields fields, ServiceContext serviceContext) throws PortalException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        DDMFormValues ddmFormValues = this.fieldsToDDMFormValuesConverter.convert(recordSet.getDDMStructure(), fields);
        return this.ddlRecordLocalService.addRecord(userId, groupId, recordSetId, displayIndex, ddmFormValues, serviceContext);
    }

    @Deprecated
    public DDLRecord addRecord(long userId, long groupId, long recordSetId, int displayIndex, Map<String, Serializable> fieldsMap, ServiceContext serviceContext) throws PortalException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Fields fields = this.toFields(ddmStructure.getStructureId(), fieldsMap, serviceContext.getLocale(), LocaleUtil.getSiteDefault());
        return this.ddlRecordLocalService.addRecord(userId, groupId, recordSetId, displayIndex, fields, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDLRecord addRecord(long userId, long groupId, long ddmStorageId, long ddlRecordSetId, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        DDLRecordSet ddlRecordSet = this.ddlRecordSetPersistence.findByPrimaryKey(ddlRecordSetId);
        this.validate(groupId, ddlRecordSet);
        long recordId = this.counterLocalService.increment();
        DDLRecord record = this.ddlRecordPersistence.create(recordId);
        record.setUuid(serviceContext.getUuid());
        record.setGroupId(groupId);
        record.setCompanyId(user.getCompanyId());
        record.setUserId(user.getUserId());
        record.setUserName(user.getFullName());
        record.setVersionUserId(user.getUserId());
        record.setVersionUserName(user.getFullName());
        record.setDDMStorageId(ddmStorageId);
        record.setRecordSetId(ddlRecordSetId);
        record.setRecordSetVersion(ddlRecordSet.getVersion());
        record.setVersion("1.0");
        record.setDisplayIndex(0);
        this.ddlRecordPersistence.update((BaseModel)record);
        int status = GetterUtil.getInteger((Object)serviceContext.getAttribute("status"), (int)0);
        this.addRecordVersion(user, record, ddmStorageId, "1.0", 0, status);
        return record;
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public DDLRecord deleteRecord(DDLRecord record) throws PortalException {
        this.ddlRecordPersistence.remove((BaseModel)record);
        List recordVersions = this.ddlRecordVersionPersistence.findByRecordId(record.getRecordId());
        for (DDLRecordVersion recordVersion : recordVersions) {
            this.ddlRecordVersionPersistence.remove((BaseModel)recordVersion);
            this.storageEngine.deleteByClass(recordVersion.getDDMStorageId());
            this.deleteWorkflowInstanceLink(record.getCompanyId(), record.getGroupId(), recordVersion.getPrimaryKey());
        }
        this.deleteAssetEntry(record.getRecordId());
        this.deleteRatingsStats(record.getRecordId());
        return record;
    }

    public void deleteRecord(long recordId) throws PortalException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        this.ddlRecordLocalService.deleteRecord(record);
    }

    @Deprecated
    public DDLRecord deleteRecordLocale(long recordId, Locale locale, ServiceContext serviceContext) throws PortalException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        DDLRecordSet recordSet = record.getRecordSet();
        DDMFormValues ddmFormValues = this.storageEngine.getDDMFormValues(record.getDDMStorageId());
        Fields fields = this.ddmFormValuesToFieldsConverter.convert(recordSet.getDDMStructure(), ddmFormValues);
        for (Field field : fields) {
            Map valuesMap = field.getValuesMap();
            valuesMap.remove(locale);
        }
        return this.ddlRecordLocalService.updateRecord(serviceContext.getUserId(), recordId, false, 0, fields, false, serviceContext);
    }

    public void deleteRecords(long recordSetId) throws PortalException {
        List records = this.ddlRecordPersistence.findByRecordSetId(recordSetId);
        for (DDLRecord record : records) {
            this.ddlRecordLocalService.deleteRecord(record);
        }
    }

    public DDLRecord fetchRecord(long recordId) {
        return this.ddlRecordPersistence.fetchByPrimaryKey(recordId);
    }

    public List<DDLRecord> getCompanyRecords(long companyId, int status, int scope, int start, int end, OrderByComparator<DDLRecord> orderByComparator) {
        return this.ddlRecordFinder.findByC_S_S(companyId, status, scope, start, end, orderByComparator);
    }

    public int getCompanyRecordsCount(long companyId, int status, int scope) {
        return this.ddlRecordFinder.countByC_S_S(companyId, status, scope);
    }

    public DDMFormValues getDDMFormValues(long ddmStorageId) throws StorageException {
        return this.storageEngine.getDDMFormValues(ddmStorageId);
    }

    @Deprecated
    public DDLRecordVersion getLatestRecordVersion(long recordId) throws PortalException {
        return this._ddlRecordVersionLocalService.getLatestRecordVersion(recordId);
    }

    public Long[] getMinAndMaxCompanyRecordIds(long companyId, int status, int scope) {
        return this.ddlRecordFinder.findByC_S_S_MinAndMax(companyId, status, scope);
    }

    public List<DDLRecord> getMinAndMaxCompanyRecords(long companyId, int status, int scope, long minRecordId, long maxRecordId) {
        return this.ddlRecordFinder.findByC_S_S_MinAndMax(companyId, status, scope, minRecordId, maxRecordId);
    }

    public DDLRecord getRecord(long recordId) throws PortalException {
        return this.ddlRecordPersistence.findByPrimaryKey(recordId);
    }

    public List<DDLRecord> getRecords(long recordSetId) {
        return this.ddlRecordPersistence.findByRecordSetId(recordSetId);
    }

    public List<DDLRecord> getRecords(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) {
        return this.ddlRecordFinder.findByR_S(recordSetId, status, start, end, orderByComparator);
    }

    public List<DDLRecord> getRecords(long recordSetId, int start, int end, OrderByComparator<DDLRecord> obc) {
        return this.ddlRecordPersistence.findByRecordSetId(recordSetId, start, end, obc);
    }

    public List<DDLRecord> getRecords(long recordSetId, long userId) {
        return this.ddlRecordPersistence.findByR_U(recordSetId, userId);
    }

    public List<DDLRecord> getRecords(long recordSetId, long userId, int start, int end, OrderByComparator<DDLRecord> obc) {
        return this.ddlRecordPersistence.findByR_U(recordSetId, userId, start, end, obc);
    }

    public int getRecordsCount(long recordSetId) {
        return this.ddlRecordPersistence.countByRecordSetId(recordSetId);
    }

    public int getRecordsCount(long recordSetId, int status) {
        return this.ddlRecordFinder.countByR_S(recordSetId, status);
    }

    public int getRecordsCount(long recordSetId, long userId) {
        return this.ddlRecordPersistence.countByR_U(recordSetId, userId);
    }

    @Deprecated
    public DDLRecordVersion getRecordVersion(long recordVersionId) throws PortalException {
        return this.ddlRecordVersionPersistence.findByPrimaryKey(recordVersionId);
    }

    @Deprecated
    public DDLRecordVersion getRecordVersion(long recordId, String version) throws PortalException {
        return this.ddlRecordVersionPersistence.findByR_V(recordId, version);
    }

    @Deprecated
    public List<DDLRecordVersion> getRecordVersions(long recordId, int start, int end, OrderByComparator<DDLRecordVersion> orderByComparator) {
        return this.ddlRecordVersionPersistence.findByRecordId(recordId, start, end, orderByComparator);
    }

    @Deprecated
    public int getRecordVersionsCount(long recordId) {
        return this.ddlRecordVersionPersistence.countByRecordId(recordId);
    }

    public void revertRecord(long userId, long recordId, String version, ServiceContext serviceContext) throws PortalException {
        DDLRecordVersion recordVersion = this._ddlRecordVersionLocalService.getRecordVersion(recordId, version);
        if (!recordVersion.isApproved()) {
            return;
        }
        DDMFormValues ddmFormValues = this.storageEngine.getDDMFormValues(recordVersion.getDDMStorageId());
        serviceContext.setCommand("revert");
        this.ddlRecordLocalService.updateRecord(userId, recordId, true, recordVersion.getDisplayIndex(), ddmFormValues, serviceContext);
    }

    @Deprecated
    public void revertRecordVersion(long userId, long recordId, String version, ServiceContext serviceContext) throws PortalException {
        this.revertRecord(userId, recordId, version, serviceContext);
    }

    public Hits search(SearchContext searchContext) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DDLRecord.class);
            return indexer.search(searchContext);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public BaseModelSearchResult<DDLRecord> searchDDLRecords(SearchContext searchContext) {
        try {
            Indexer<DDLRecord> indexer = this.getDDLRecordIndexer();
            Hits hits = indexer.search(searchContext, DDL.SELECTED_FIELD_NAMES);
            return new BaseModelSearchResult(this.getRecords(hits), hits.getLength());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void updateAsset(long userId, DDLRecord record, DDLRecordVersion recordVersion, long[] assetCategoryIds, String[] assetTagNames, Locale locale, Double priority) throws PortalException {
        DDLRecordSet recordSet = record.getRecordSet();
        int scope = recordSet.getScope();
        if (scope != 0 && scope != 2 && scope != 1) {
            return;
        }
        boolean addDraftAssetEntry = false;
        boolean visible = true;
        if (recordVersion != null && !recordVersion.isApproved()) {
            int approvedRecordVersionsCount;
            String version = recordVersion.getVersion();
            if (!version.equals("1.0") && (approvedRecordVersionsCount = this.ddlRecordVersionPersistence.countByR_S(record.getRecordId(), 0)) > 0) {
                addDraftAssetEntry = true;
            }
            visible = false;
        }
        if (scope == 2) {
            visible = false;
        }
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        String ddmStructureName = ddmStructure.getName(locale);
        String recordSetName = recordSet.getName(locale);
        String title = LanguageUtil.format((Locale)locale, (String)"new-x-for-list-x", (Object[])new Object[]{ddmStructureName, recordSetName}, (boolean)false);
        if (addDraftAssetEntry) {
            this.assetEntryLocalService.updateEntry(userId, record.getGroupId(), record.getCreateDate(), record.getModifiedDate(), DDLRecordConstants.getClassName((int)scope), recordVersion.getRecordVersionId(), record.getUuid(), 0L, assetCategoryIds, assetTagNames, true, false, null, null, null, null, "text/html", title, null, "", null, null, 0, 0, priority);
        } else {
            Date publishDate = null;
            if (visible) {
                publishDate = record.getCreateDate();
            }
            this.assetEntryLocalService.updateEntry(userId, record.getGroupId(), record.getCreateDate(), record.getModifiedDate(), DDLRecordConstants.getClassName((int)scope), record.getRecordId(), record.getUuid(), 0L, assetCategoryIds, assetTagNames, true, visible, null, null, publishDate, null, "text/html", title, null, "", null, null, 0, 0, priority);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDLRecord updateRecord(long userId, long recordId, boolean majorVersion, int displayIndex, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        record.setModifiedDate(serviceContext.getModifiedDate(null));
        record = (DDLRecord)this.ddlRecordPersistence.update((BaseModel)record);
        DDLRecordVersion recordVersion = record.getLatestRecordVersion();
        if (recordVersion.isApproved()) {
            DDLRecordSet recordSet = record.getRecordSet();
            long ddmStorageId = this.storageEngine.create(recordSet.getCompanyId(), recordSet.getDDMStructureId(), ddmFormValues, serviceContext);
            String version = this.getNextVersion(recordVersion.getVersion(), majorVersion, serviceContext.getWorkflowAction());
            recordVersion = this.addRecordVersion(user, record, ddmStorageId, version, displayIndex, 2);
        } else {
            this.storageEngine.update(recordVersion.getDDMStorageId(), ddmFormValues, serviceContext);
            this.updateRecordVersion(user, recordVersion, recordVersion.getVersion(), displayIndex, recordVersion.getStatus(), serviceContext);
        }
        this.updateAsset(userId, record, recordVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getLocale(), serviceContext.getAssetPriority());
        if (this.isKeepRecordVersionLabel(record.getRecordVersion(), recordVersion, serviceContext)) {
            this.ddlRecordVersionPersistence.remove((BaseModel)recordVersion);
            this.storageEngine.deleteByClass(recordVersion.getDDMStorageId());
            return record;
        }
        if (serviceContext.getWorkflowAction() == 1) {
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)record.getGroupId(), (long)userId, (String)this.getWorkflowAssetClassName(record.getRecordSet()), (long)recordVersion.getRecordVersionId(), (Object)recordVersion, (ServiceContext)serviceContext);
        }
        return record;
    }

    @Deprecated
    public DDLRecord updateRecord(long userId, long recordId, boolean majorVersion, int displayIndex, Fields fields, boolean mergeFields, ServiceContext serviceContext) throws PortalException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        DDLRecordSet recordSet = record.getRecordSet();
        if (mergeFields) {
            DDLRecordVersion recordVersion = record.getLatestRecordVersion();
            DDMFormValues existingDDMFormValues = this.storageEngine.getDDMFormValues(recordVersion.getDDMStorageId());
            Fields existingFields = this.ddmFormValuesToFieldsConverter.convert(recordSet.getDDMStructure(), existingDDMFormValues);
            fields = this.ddm.mergeFields(fields, existingFields);
        }
        DDMFormValues ddmFormValues = this.fieldsToDDMFormValuesConverter.convert(recordSet.getDDMStructure(), fields);
        return this.ddlRecordLocalService.updateRecord(userId, recordId, majorVersion, displayIndex, ddmFormValues, serviceContext);
    }

    @Deprecated
    public DDLRecord updateRecord(long userId, long recordId, int displayIndex, Map<String, Serializable> fieldsMap, boolean mergeFields, ServiceContext serviceContext) throws PortalException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        DDMFormValues oldDDMFormValues = record.getDDMFormValues();
        DDLRecordSet recordSet = record.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Fields fields = this.toFields(ddmStructure.getStructureId(), fieldsMap, serviceContext.getLocale(), oldDDMFormValues.getDefaultLocale());
        return this.ddlRecordLocalService.updateRecord(userId, recordId, false, displayIndex, fields, mergeFields, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDLRecord updateRecord(long userId, long recordId, long ddmStorageId, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        record.setModifiedDate(serviceContext.getModifiedDate(null));
        record.setDDMStorageId(ddmStorageId);
        record = (DDLRecord)this.ddlRecordPersistence.update((BaseModel)record);
        DDLRecordVersion ddlRecordVersion = record.getLatestRecordVersion();
        String version = this.getNextVersion(ddlRecordVersion.getVersion(), true, serviceContext.getWorkflowAction());
        int status = GetterUtil.getInteger((Object)serviceContext.getAttribute("status"), (int)0);
        this.addRecordVersion(user, record, ddmStorageId, version, 0, status);
        return record;
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDLRecord updateStatus(long userId, long recordVersionId, int status, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        DDLRecordVersion recordVersion = this.ddlRecordVersionPersistence.findByPrimaryKey(recordVersionId);
        recordVersion.setStatus(status);
        recordVersion.setStatusByUserId(user.getUserId());
        recordVersion.setStatusByUserName(user.getFullName());
        recordVersion.setStatusDate(new Date());
        this.ddlRecordVersionPersistence.update((BaseModel)recordVersion);
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordVersion.getRecordId());
        if (status == 0) {
            int compare = DLUtil.compareVersions((String)record.getVersion(), (String)recordVersion.getVersion());
            if (compare <= 0) {
                record.setDDMStorageId(recordVersion.getDDMStorageId());
                record.setRecordSetId(recordVersion.getRecordSetId());
                record.setVersion(recordVersion.getVersion());
                record.setDisplayIndex(recordVersion.getDisplayIndex());
                record.setVersion(recordVersion.getVersion());
                record.setVersionUserId(recordVersion.getUserId());
                record.setVersionUserName(recordVersion.getUserName());
                this.ddlRecordPersistence.update((BaseModel)record);
            }
        } else if (Objects.equals(record.getVersion(), recordVersion.getVersion())) {
            String newVersion = "1.0";
            List approvedRecordVersions = this.ddlRecordVersionPersistence.findByR_S(record.getRecordId(), 0);
            if (!approvedRecordVersions.isEmpty()) {
                DDLRecordVersion approvedRecordVersion = (DDLRecordVersion)approvedRecordVersions.get(0);
                newVersion = approvedRecordVersion.getVersion();
            }
            record.setVersion(newVersion);
            this.ddlRecordPersistence.update((BaseModel)record);
        }
        this.updateAsset(userId, record, recordVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getLocale(), serviceContext.getAssetPriority());
        return record;
    }

    protected DDLRecordVersion addRecordVersion(User user, DDLRecord record, long ddmStorageId, String version, int displayIndex, int status) {
        long recordVersionId = this.counterLocalService.increment();
        DDLRecordVersion recordVersion = this.ddlRecordVersionPersistence.create(recordVersionId);
        recordVersion.setGroupId(record.getGroupId());
        recordVersion.setCompanyId(record.getCompanyId());
        recordVersion.setUserId(user.getUserId());
        recordVersion.setUserName(user.getFullName());
        recordVersion.setCreateDate(record.getModifiedDate());
        recordVersion.setDDMStorageId(ddmStorageId);
        recordVersion.setRecordSetId(record.getRecordSetId());
        recordVersion.setRecordSetVersion(record.getRecordSetVersion());
        recordVersion.setRecordId(record.getRecordId());
        recordVersion.setVersion(version);
        recordVersion.setDisplayIndex(displayIndex);
        recordVersion.setStatus(status);
        recordVersion.setStatusByUserId(user.getUserId());
        recordVersion.setStatusByUserName(user.getFullName());
        recordVersion.setStatusDate(record.getModifiedDate());
        this.ddlRecordVersionPersistence.update((BaseModel)recordVersion);
        return recordVersion;
    }

    protected void deleteAssetEntry(long recordId) throws PortalException {
        this.assetEntryLocalService.deleteEntry(DDLFormRecord.class.getName(), recordId);
        this.assetEntryLocalService.deleteEntry(DDLRecord.class.getName(), recordId);
    }

    protected void deleteRatingsStats(long recordId) throws PortalException {
        this.ratingsStatsLocalService.deleteStats(DDLFormRecord.class.getName(), recordId);
        this.ratingsStatsLocalService.deleteStats(DDLRecord.class.getName(), recordId);
    }

    protected void deleteWorkflowInstanceLink(long companyId, long groupId, long recordVersionId) throws PortalException {
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(companyId, groupId, DDLFormRecord.class.getName(), recordVersionId);
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(companyId, groupId, DDLRecord.class.getName(), recordVersionId);
    }

    protected Indexer<DDLRecord> getDDLRecordIndexer() {
        return this.indexerRegistry.nullSafeGetIndexer(DDLRecord.class);
    }

    protected String getNextVersion(String version, boolean majorVersion, int workflowAction) {
        if (workflowAction == 2) {
            majorVersion = false;
        }
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        if (majorVersion) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return versionParts[0] + "." + versionParts[1];
    }

    protected List<DDLRecord> getRecords(Hits hits) throws PortalException {
        ArrayList<DDLRecord> records = new ArrayList<DDLRecord>();
        for (Document document : hits.toList()) {
            long recordId = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                records.add(this.getRecord(recordId));
            }
            catch (NoSuchRecordException nsre) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("DDL record index is stale and contains record " + recordId), (Throwable)nsre);
                }
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                Indexer<DDLRecord> indexer = this.getDDLRecordIndexer();
                indexer.delete(companyId, document.getUID());
            }
        }
        return records;
    }

    protected String getWorkflowAssetClassName(DDLRecordSet recordSet) {
        if (recordSet.getScope() == 2) {
            return DDLFormRecord.class.getName();
        }
        return DDLRecord.class.getName();
    }

    protected boolean isKeepRecordVersionLabel(DDLRecordVersion lastRecordVersion, DDLRecordVersion latestRecordVersion, ServiceContext serviceContext) throws PortalException {
        Map latestAttributes;
        DDMFormValues latestDDMFormValues;
        if (Objects.equals(serviceContext.getCommand(), "revert")) {
            return false;
        }
        if (serviceContext.getWorkflowAction() == 2) {
            return false;
        }
        if (Objects.equals(lastRecordVersion.getVersion(), latestRecordVersion.getVersion())) {
            return false;
        }
        DDMFormValues lastDDMFormValues = this.storageEngine.getDDMFormValues(lastRecordVersion.getDDMStorageId());
        if (!lastDDMFormValues.equals((Object)(latestDDMFormValues = this.storageEngine.getDDMFormValues(latestRecordVersion.getDDMStorageId())))) {
            return false;
        }
        ExpandoBridge lastExpandoBridge = lastRecordVersion.getExpandoBridge();
        ExpandoBridge latestExpandoBridge = latestRecordVersion.getExpandoBridge();
        Map lastAttributes = lastExpandoBridge.getAttributes();
        return lastAttributes.equals(latestAttributes = latestExpandoBridge.getAttributes());
    }

    protected Fields toFields(long ddmStructureId, Map<String, Serializable> fieldsMap, Locale locale, Locale defaultLocale) {
        Fields fields = new Fields();
        for (Map.Entry<String, Serializable> entry : fieldsMap.entrySet()) {
            Field field = new Field();
            field.setDDMStructureId(ddmStructureId);
            field.setName(entry.getKey());
            Serializable value = entry.getValue();
            List<Serializable> serializableValues = this._getSerializableValues(value);
            if (serializableValues != null) {
                field.addValues(locale, serializableValues);
                if (!locale.equals(defaultLocale)) {
                    field.addValues(defaultLocale, serializableValues);
                }
            } else {
                field.addValue(locale, value);
                if (!locale.equals(defaultLocale)) {
                    field.addValue(defaultLocale, value);
                }
            }
            field.setDefaultLocale(defaultLocale);
            fields.put(field);
        }
        Field fieldsDisplayField = fields.get(_FIELDS_DISPLAY_NAME);
        if (fieldsDisplayField == null) {
            StringBundler fieldsDisplayFieldSB = new StringBundler(fieldsMap.size() * 4 - 1);
            for (String fieldName : fields.getNames()) {
                fieldsDisplayFieldSB.append(fieldName);
                fieldsDisplayFieldSB.append(_INSTANCE_SEPARATOR);
                fieldsDisplayFieldSB.append(StringUtil.randomString());
                fieldsDisplayFieldSB.append(",");
            }
            if (fieldsDisplayFieldSB.index() > 0) {
                fieldsDisplayFieldSB.setIndex(fieldsDisplayFieldSB.index() - 1);
            }
            fieldsDisplayField = new Field(ddmStructureId, _FIELDS_DISPLAY_NAME, (Serializable)((Object)fieldsDisplayFieldSB.toString()));
            fields.put(fieldsDisplayField);
        }
        return fields;
    }

    protected void updateRecordVersion(User user, DDLRecordVersion recordVersion, String version, int displayIndex, int status, ServiceContext serviceContext) {
        recordVersion.setUserId(user.getUserId());
        recordVersion.setUserName(user.getFullName());
        recordVersion.setVersion(version);
        recordVersion.setDisplayIndex(displayIndex);
        recordVersion.setStatus(status);
        recordVersion.setStatusByUserId(user.getUserId());
        recordVersion.setStatusByUserName(user.getFullName());
        recordVersion.setStatusDate(serviceContext.getModifiedDate(null));
        this.ddlRecordVersionPersistence.update((BaseModel)recordVersion);
    }

    protected void validate(long groupId, DDLRecordSet recordSet) throws PortalException {
        if (recordSet.getGroupId() != groupId) {
            throw new RecordGroupIdException("Record group ID is not the same as the record set group ID");
        }
    }

    private List<Serializable> _getSerializableValues(Serializable value) {
        List<Serializable> serializableValues;
        block7: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block6: {
                                        serializableValues = null;
                                        if (!(value instanceof Collection)) break block6;
                                        Collection values = (Collection)((Object)value);
                                        serializableValues = new ArrayList<Serializable>(values);
                                        break block7;
                                    }
                                    if (!(value instanceof Serializable[])) break block8;
                                    Object[] values = (Serializable[])value;
                                    serializableValues = ListUtil.fromArray((Object[])values);
                                    break block7;
                                }
                                if (!(value instanceof boolean[])) break block9;
                                boolean[] values = (boolean[])value;
                                serializableValues = new ArrayList(values.length);
                                for (boolean serializableValue : values) {
                                    serializableValues.add(Boolean.valueOf(serializableValue));
                                }
                                break block7;
                            }
                            if (!(value instanceof double[])) break block10;
                            double[] values = (double[])value;
                            serializableValues = new ArrayList(values.length);
                            for (double serializableValue : values) {
                                serializableValues.add(Double.valueOf(serializableValue));
                            }
                            break block7;
                        }
                        if (!(value instanceof float[])) break block11;
                        float[] values = (float[])value;
                        serializableValues = new ArrayList(values.length);
                        for (float serializableValue : values) {
                            serializableValues.add(Float.valueOf(serializableValue));
                        }
                        break block7;
                    }
                    if (!(value instanceof int[])) break block12;
                    int[] values = (int[])value;
                    serializableValues = new ArrayList(values.length);
                    for (int serializableValue : values) {
                        serializableValues.add(Integer.valueOf(serializableValue));
                    }
                    break block7;
                }
                if (!(value instanceof long[])) break block13;
                long[] values = (long[])value;
                serializableValues = new ArrayList(values.length);
                for (long serializableValue : values) {
                    serializableValues.add(Long.valueOf(serializableValue));
                }
                break block7;
            }
            if (!(value instanceof short[])) break block7;
            short[] values = (short[])value;
            serializableValues = new ArrayList(values.length);
            for (short serializableValue : values) {
                serializableValues.add(Short.valueOf(serializableValue));
            }
        }
        return serializableValues;
    }
}

