/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.lists.service.base;

import com.liferay.dynamic.data.lists.model.DDLRecordSetVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordSetVersionService;
import com.liferay.dynamic.data.lists.service.persistence.DDLRecordSetVersionPersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the ddl record set version remote service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.dynamic.data.lists.service.impl.DDLRecordSetVersionServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see com.liferay.dynamic.data.lists.service.impl.DDLRecordSetVersionServiceImpl
 * @generated
 */
public abstract class DDLRecordSetVersionServiceBaseImpl
	extends BaseServiceImpl
	implements DDLRecordSetVersionService, IdentifiableOSGiService {

	/**
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>DDLRecordSetVersionService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>com.liferay.dynamic.data.lists.service.DDLRecordSetVersionServiceUtil</code>.
	 */

	/**
	 * Returns the ddl record set version local service.
	 *
	 * @return the ddl record set version local service
	 */
	public
		com.liferay.dynamic.data.lists.service.DDLRecordSetVersionLocalService
			getDDLRecordSetVersionLocalService() {

		return ddlRecordSetVersionLocalService;
	}

	/**
	 * Sets the ddl record set version local service.
	 *
	 * @param ddlRecordSetVersionLocalService the ddl record set version local service
	 */
	public void setDDLRecordSetVersionLocalService(
		com.liferay.dynamic.data.lists.service.DDLRecordSetVersionLocalService
			ddlRecordSetVersionLocalService) {

		this.ddlRecordSetVersionLocalService = ddlRecordSetVersionLocalService;
	}

	/**
	 * Returns the ddl record set version remote service.
	 *
	 * @return the ddl record set version remote service
	 */
	public DDLRecordSetVersionService getDDLRecordSetVersionService() {
		return ddlRecordSetVersionService;
	}

	/**
	 * Sets the ddl record set version remote service.
	 *
	 * @param ddlRecordSetVersionService the ddl record set version remote service
	 */
	public void setDDLRecordSetVersionService(
		DDLRecordSetVersionService ddlRecordSetVersionService) {

		this.ddlRecordSetVersionService = ddlRecordSetVersionService;
	}

	/**
	 * Returns the ddl record set version persistence.
	 *
	 * @return the ddl record set version persistence
	 */
	public DDLRecordSetVersionPersistence getDDLRecordSetVersionPersistence() {
		return ddlRecordSetVersionPersistence;
	}

	/**
	 * Sets the ddl record set version persistence.
	 *
	 * @param ddlRecordSetVersionPersistence the ddl record set version persistence
	 */
	public void setDDLRecordSetVersionPersistence(
		DDLRecordSetVersionPersistence ddlRecordSetVersionPersistence) {

		this.ddlRecordSetVersionPersistence = ddlRecordSetVersionPersistence;
	}

	/**
	 * Returns the counter local service.
	 *
	 * @return the counter local service
	 */
	public com.liferay.counter.kernel.service.CounterLocalService
		getCounterLocalService() {

		return counterLocalService;
	}

	/**
	 * Sets the counter local service.
	 *
	 * @param counterLocalService the counter local service
	 */
	public void setCounterLocalService(
		com.liferay.counter.kernel.service.CounterLocalService
			counterLocalService) {

		this.counterLocalService = counterLocalService;
	}

	public void afterPropertiesSet() {
	}

	public void destroy() {
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return DDLRecordSetVersionService.class.getName();
	}

	protected Class<?> getModelClass() {
		return DDLRecordSetVersion.class;
	}

	protected String getModelClassName() {
		return DDLRecordSetVersion.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		try {
			DataSource dataSource =
				ddlRecordSetVersionPersistence.getDataSource();

			DB db = DBManagerUtil.getDB();

			sql = db.buildSQL(sql);
			sql = PortalUtil.transformSQL(sql);

			SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(
				dataSource, sql);

			sqlUpdate.update();
		}
		catch (Exception e) {
			throw new SystemException(e);
		}
	}

	@BeanReference(
		type = com.liferay.dynamic.data.lists.service.DDLRecordSetVersionLocalService.class
	)
	protected
		com.liferay.dynamic.data.lists.service.DDLRecordSetVersionLocalService
			ddlRecordSetVersionLocalService;

	@BeanReference(type = DDLRecordSetVersionService.class)
	protected DDLRecordSetVersionService ddlRecordSetVersionService;

	@BeanReference(type = DDLRecordSetVersionPersistence.class)
	protected DDLRecordSetVersionPersistence ddlRecordSetVersionPersistence;

	@ServiceReference(
		type = com.liferay.counter.kernel.service.CounterLocalService.class
	)
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

}