/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.permission;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalServiceUtil;
import com.liferay.dynamic.data.lists.service.permission.DDLRecordSetPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;

public class DDLRecordPermission {
    public static void check(PermissionChecker permissionChecker, DDLRecord record, String actionId) throws PortalException {
        if (!DDLRecordPermission.contains(permissionChecker, record, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DDLRecord.class.getName(), record.getRecordId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long recordId, String actionId) throws PortalException {
        if (!DDLRecordPermission.contains(permissionChecker, recordId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DDLRecord.class.getName(), recordId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DDLRecord record, String actionId) throws PortalException {
        DDLRecordSet recordSet = record.getRecordSet();
        return DDLRecordSetPermission.contains(permissionChecker, recordSet, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long recordId, String actionId) throws PortalException {
        DDLRecord record = DDLRecordLocalServiceUtil.getRecord((long)recordId);
        return DDLRecordPermission.contains(permissionChecker, record, actionId);
    }
}

