/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.workflow;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.dynamic.data.lists.model.DDLFormRecord;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.model.impl.DDLFormRecordImpl;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordVersionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.workflow.BaseWorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={WorkflowHandler.class})
public class DDLFormWorkflowHandler
extends BaseWorkflowHandler<DDLFormRecord> {
    private DDLRecordLocalService _ddlRecordLocalService;
    private DDLRecordVersionLocalService _ddlRecordVersionLocalService;
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public AssetRenderer<DDLFormRecord> getAssetRenderer(long classPK) throws PortalException {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        if (assetRendererFactory == null) {
            return null;
        }
        DDLRecordVersion recordVersion = this._ddlRecordVersionLocalService.getRecordVersion(classPK);
        return assetRendererFactory.getAssetRenderer(recordVersion.getRecordId(), 0);
    }

    public String getClassName() {
        return DDLFormRecord.class.getName();
    }

    public String getType(Locale locale) {
        return ResourceActionsUtil.getModelResource((Locale)locale, (String)this.getClassName());
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, long classPK) throws PortalException {
        DDLRecordVersion recordVersion = this._ddlRecordVersionLocalService.getRecordVersion(classPK);
        DDLRecord record = recordVersion.getRecord();
        return this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(companyId, groupId, DDLRecordSet.class.getName(), record.getRecordSetId(), 0L);
    }

    public boolean isVisible() {
        return false;
    }

    public DDLFormRecord updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException {
        long userId = GetterUtil.getLong((String)((String)((Object)workflowContext.get("userId"))));
        long classPK = GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK"))));
        ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
        DDLRecord record = this._ddlRecordLocalService.updateStatus(userId, classPK, status, serviceContext);
        return new DDLFormRecordImpl(record);
    }

    @Reference(unbind="-")
    protected void setDDLRecordLocalService(DDLRecordLocalService ddlRecordLocalService) {
        this._ddlRecordLocalService = ddlRecordLocalService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordVersionLocalService(DDLRecordVersionLocalService ddlRecordVersionLocalService) {
        this._ddlRecordVersionLocalService = ddlRecordVersionLocalService;
    }

    @Reference(unbind="-")
    protected void setWorkflowDefinitionLinkLocalService(WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService) {
        this._workflowDefinitionLinkLocalService = workflowDefinitionLinkLocalService;
    }
}

