/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.model.listener;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class DDMStructureModelListener
extends BaseModelListener<DDMStructure> {
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterUpdate(DDMStructure ddmStructure) throws ModelListenerException {
        try {
            ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery(ddmStructure);
            actionableDynamicQuery.performActions();
        }
        catch (PortalException pe) {
            throw new ModelListenerException((Throwable)pe);
        }
    }

    protected ActionableDynamicQuery getActionableDynamicQuery(final DDMStructure ddmStructure) {
        ActionableDynamicQuery actionableDynamicQuery = this._ddlRecordSetLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property ddmStructureIdProperty = PropertyFactoryUtil.forName((String)"DDMStructureId");
                dynamicQuery.add(ddmStructureIdProperty.eq((Object)ddmStructure.getStructureId()));
            }
        });
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DDLRecordSet>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void performAction(DDLRecordSet recordSet) throws PortalException {
                Locale siteLocale = null;
                if (ExportImportThreadLocal.isImportInProcess()) {
                    siteLocale = LocaleThreadLocal.getSiteDefaultLocale();
                    Locale stagingLocale = LocaleUtil.fromLanguageId((String)ddmStructure.getDefaultLanguageId());
                    LocaleThreadLocal.setSiteDefaultLocale((Locale)stagingLocale);
                }
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                serviceContext.setScopeGroupId(recordSet.getGroupId());
                long defaultUserId = DDMStructureModelListener.this._userLocalService.getDefaultUserId(recordSet.getCompanyId());
                serviceContext.setUserId(defaultUserId);
                try {
                    Locale recordSetLocale = LocaleUtil.fromLanguageId((String)recordSet.getDefaultLanguageId());
                    Locale siteDefaultLocale = LocaleUtil.getSiteDefault();
                    if (!recordSetLocale.equals(siteDefaultLocale)) {
                        recordSet.setDescription(recordSet.getDescription(recordSetLocale), siteDefaultLocale);
                        recordSet.setName(recordSet.getName(recordSetLocale), siteDefaultLocale);
                    }
                    DDMStructureModelListener.this._ddlRecordSetLocalService.updateRecordSet(recordSet.getRecordSetId(), ddmStructure.getStructureId(), recordSet.getNameMap(), recordSet.getDescriptionMap(), recordSet.getMinDisplayRows(), serviceContext);
                }
                finally {
                    if (ExportImportThreadLocal.isImportInProcess()) {
                        LocaleThreadLocal.setSiteDefaultLocale((Locale)siteLocale);
                    }
                }
            }
        });
        return actionableDynamicQuery;
    }
}

