/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.dynamic.data.lists.exception.NoSuchRecordVersionException;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.model.impl.DDLRecordVersionImpl;
import com.liferay.dynamic.data.lists.model.impl.DDLRecordVersionModelImpl;
import com.liferay.dynamic.data.lists.service.persistence.DDLRecordVersionPersistence;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ProviderType
public class DDLRecordVersionPersistenceImpl
extends BasePersistenceImpl<DDLRecordVersion>
implements DDLRecordVersionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DDLRecordVersionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByRecordId;
    private FinderPath _finderPathWithoutPaginationFindByRecordId;
    private FinderPath _finderPathCountByRecordId;
    private static final String _FINDER_COLUMN_RECORDID_RECORDID_2 = "ddlRecordVersion.recordId = ?";
    private FinderPath _finderPathFetchByR_V;
    private FinderPath _finderPathCountByR_V;
    private static final String _FINDER_COLUMN_R_V_RECORDID_2 = "ddlRecordVersion.recordId = ? AND ";
    private static final String _FINDER_COLUMN_R_V_VERSION_2 = "ddlRecordVersion.version = ?";
    private static final String _FINDER_COLUMN_R_V_VERSION_3 = "(ddlRecordVersion.version IS NULL OR ddlRecordVersion.version = '')";
    private FinderPath _finderPathWithPaginationFindByR_S;
    private FinderPath _finderPathWithoutPaginationFindByR_S;
    private FinderPath _finderPathCountByR_S;
    private static final String _FINDER_COLUMN_R_S_RECORDID_2 = "ddlRecordVersion.recordId = ? AND ";
    private static final String _FINDER_COLUMN_R_S_STATUS_2 = "ddlRecordVersion.status = ?";
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_DDLRECORDVERSION = "SELECT ddlRecordVersion FROM DDLRecordVersion ddlRecordVersion";
    private static final String _SQL_SELECT_DDLRECORDVERSION_WHERE_PKS_IN = "SELECT ddlRecordVersion FROM DDLRecordVersion ddlRecordVersion WHERE recordVersionId IN (";
    private static final String _SQL_SELECT_DDLRECORDVERSION_WHERE = "SELECT ddlRecordVersion FROM DDLRecordVersion ddlRecordVersion WHERE ";
    private static final String _SQL_COUNT_DDLRECORDVERSION = "SELECT COUNT(ddlRecordVersion) FROM DDLRecordVersion ddlRecordVersion";
    private static final String _SQL_COUNT_DDLRECORDVERSION_WHERE = "SELECT COUNT(ddlRecordVersion) FROM DDLRecordVersion ddlRecordVersion WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ddlRecordVersion.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DDLRecordVersion exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DDLRecordVersion exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(DDLRecordVersionPersistenceImpl.class);

    public List<DDLRecordVersion> findByRecordId(long recordId) {
        return this.findByRecordId(recordId, -1, -1, null);
    }

    public List<DDLRecordVersion> findByRecordId(long recordId, int start, int end) {
        return this.findByRecordId(recordId, start, end, null);
    }

    public List<DDLRecordVersion> findByRecordId(long recordId, int start, int end, OrderByComparator<DDLRecordVersion> orderByComparator) {
        return this.findByRecordId(recordId, start, end, orderByComparator, true);
    }

    public List<DDLRecordVersion> findByRecordId(long recordId, int start, int end, OrderByComparator<DDLRecordVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByRecordId;
            finderArgs = new Object[]{recordId};
        } else {
            finderPath = this._finderPathWithPaginationFindByRecordId;
            finderArgs = new Object[]{recordId, start, end, orderByComparator};
        }
        List<DDLRecordVersion> list = null;
        if (retrieveFromCache && (list = (List<DDLRecordVersion>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDLRecordVersion ddlRecordVersion : list) {
                if (recordId == ddlRecordVersion.getRecordId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_DDLRECORDVERSION_WHERE);
            query.append(_FINDER_COLUMN_RECORDID_RECORDID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY ddlRecordVersion.recordVersionId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(recordId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDLRecordVersion findByRecordId_First(long recordId, OrderByComparator<DDLRecordVersion> orderByComparator) throws NoSuchRecordVersionException {
        DDLRecordVersion ddlRecordVersion = this.fetchByRecordId_First(recordId, orderByComparator);
        if (ddlRecordVersion != null) {
            return ddlRecordVersion;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("recordId=");
        msg.append(recordId);
        msg.append("}");
        throw new NoSuchRecordVersionException(msg.toString());
    }

    public DDLRecordVersion fetchByRecordId_First(long recordId, OrderByComparator<DDLRecordVersion> orderByComparator) {
        List<DDLRecordVersion> list = this.findByRecordId(recordId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecordVersion findByRecordId_Last(long recordId, OrderByComparator<DDLRecordVersion> orderByComparator) throws NoSuchRecordVersionException {
        DDLRecordVersion ddlRecordVersion = this.fetchByRecordId_Last(recordId, orderByComparator);
        if (ddlRecordVersion != null) {
            return ddlRecordVersion;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("recordId=");
        msg.append(recordId);
        msg.append("}");
        throw new NoSuchRecordVersionException(msg.toString());
    }

    public DDLRecordVersion fetchByRecordId_Last(long recordId, OrderByComparator<DDLRecordVersion> orderByComparator) {
        int count = this.countByRecordId(recordId);
        if (count == 0) {
            return null;
        }
        List<DDLRecordVersion> list = this.findByRecordId(recordId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecordVersion[] findByRecordId_PrevAndNext(long recordVersionId, long recordId, OrderByComparator<DDLRecordVersion> orderByComparator) throws NoSuchRecordVersionException {
        DDLRecordVersion ddlRecordVersion = this.findByPrimaryKey(recordVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DDLRecordVersion[] array = new DDLRecordVersionImpl[]{this.getByRecordId_PrevAndNext(session, ddlRecordVersion, recordId, orderByComparator, true), ddlRecordVersion, this.getByRecordId_PrevAndNext(session, ddlRecordVersion, recordId, orderByComparator, false)};
            DDLRecordVersion[] dDLRecordVersionArray = array;
            return dDLRecordVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDLRecordVersion getByRecordId_PrevAndNext(Session session, DDLRecordVersion ddlRecordVersion, long recordId, OrderByComparator<DDLRecordVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_DDLRECORDVERSION_WHERE);
        query.append(_FINDER_COLUMN_RECORDID_RECORDID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ddlRecordVersion.recordVersionId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(recordId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddlRecordVersion)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DDLRecordVersion)list.get(1);
        }
        return null;
    }

    public void removeByRecordId(long recordId) {
        for (DDLRecordVersion ddlRecordVersion : this.findByRecordId(recordId, -1, -1, null)) {
            this.remove((BaseModel)ddlRecordVersion);
        }
    }

    public int countByRecordId(long recordId) {
        FinderPath finderPath = this._finderPathCountByRecordId;
        Object[] finderArgs = new Object[]{recordId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_DDLRECORDVERSION_WHERE);
            query.append(_FINDER_COLUMN_RECORDID_RECORDID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(recordId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDLRecordVersion findByR_V(long recordId, String version) throws NoSuchRecordVersionException {
        DDLRecordVersion ddlRecordVersion = this.fetchByR_V(recordId, version);
        if (ddlRecordVersion == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("recordId=");
            msg.append(recordId);
            msg.append(", version=");
            msg.append(version);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchRecordVersionException(msg.toString());
        }
        return ddlRecordVersion;
    }

    public DDLRecordVersion fetchByR_V(long recordId, String version) {
        return this.fetchByR_V(recordId, version, true);
    }

    public DDLRecordVersion fetchByR_V(long recordId, String version, boolean retrieveFromCache) {
        DDLRecordVersion ddlRecordVersion;
        version = Objects.toString(version, "");
        Object[] finderArgs = new Object[]{recordId, version};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(this._finderPathFetchByR_V, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof DDLRecordVersion && (recordId != (ddlRecordVersion = (DDLRecordVersion)result).getRecordId() || !Objects.equals(version, ddlRecordVersion.getVersion()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_DDLRECORDVERSION_WHERE);
            query.append("ddlRecordVersion.recordId = ? AND ");
            boolean bindVersion = false;
            if (version.isEmpty()) {
                query.append(_FINDER_COLUMN_R_V_VERSION_3);
            } else {
                bindVersion = true;
                query.append(_FINDER_COLUMN_R_V_VERSION_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(recordId);
                if (bindVersion) {
                    qPos.add(version);
                }
                if ((list = q.list()).isEmpty()) {
                    this.finderCache.putResult(this._finderPathFetchByR_V, finderArgs, (Object)list);
                } else {
                    DDLRecordVersion ddlRecordVersion2 = (DDLRecordVersion)list.get(0);
                    result = ddlRecordVersion2;
                    this.cacheResult(ddlRecordVersion2);
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathFetchByR_V, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DDLRecordVersion)result;
    }

    public DDLRecordVersion removeByR_V(long recordId, String version) throws NoSuchRecordVersionException {
        DDLRecordVersion ddlRecordVersion = this.findByR_V(recordId, version);
        return (DDLRecordVersion)this.remove((BaseModel)ddlRecordVersion);
    }

    public int countByR_V(long recordId, String version) {
        version = Objects.toString(version, "");
        FinderPath finderPath = this._finderPathCountByR_V;
        Object[] finderArgs = new Object[]{recordId, version};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DDLRECORDVERSION_WHERE);
            query.append("ddlRecordVersion.recordId = ? AND ");
            boolean bindVersion = false;
            if (version.isEmpty()) {
                query.append(_FINDER_COLUMN_R_V_VERSION_3);
            } else {
                bindVersion = true;
                query.append(_FINDER_COLUMN_R_V_VERSION_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(recordId);
                if (bindVersion) {
                    qPos.add(version);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DDLRecordVersion> findByR_S(long recordId, int status) {
        return this.findByR_S(recordId, status, -1, -1, null);
    }

    public List<DDLRecordVersion> findByR_S(long recordId, int status, int start, int end) {
        return this.findByR_S(recordId, status, start, end, null);
    }

    public List<DDLRecordVersion> findByR_S(long recordId, int status, int start, int end, OrderByComparator<DDLRecordVersion> orderByComparator) {
        return this.findByR_S(recordId, status, start, end, orderByComparator, true);
    }

    public List<DDLRecordVersion> findByR_S(long recordId, int status, int start, int end, OrderByComparator<DDLRecordVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByR_S;
            finderArgs = new Object[]{recordId, status};
        } else {
            finderPath = this._finderPathWithPaginationFindByR_S;
            finderArgs = new Object[]{recordId, status, start, end, orderByComparator};
        }
        List<DDLRecordVersion> list = null;
        if (retrieveFromCache && (list = (List<DDLRecordVersion>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DDLRecordVersion ddlRecordVersion : list) {
                if (recordId == ddlRecordVersion.getRecordId() && status == ddlRecordVersion.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_DDLRECORDVERSION_WHERE);
            query.append("ddlRecordVersion.recordId = ? AND ");
            query.append(_FINDER_COLUMN_R_S_STATUS_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY ddlRecordVersion.recordVersionId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(recordId);
                qPos.add(status);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DDLRecordVersion findByR_S_First(long recordId, int status, OrderByComparator<DDLRecordVersion> orderByComparator) throws NoSuchRecordVersionException {
        DDLRecordVersion ddlRecordVersion = this.fetchByR_S_First(recordId, status, orderByComparator);
        if (ddlRecordVersion != null) {
            return ddlRecordVersion;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("recordId=");
        msg.append(recordId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchRecordVersionException(msg.toString());
    }

    public DDLRecordVersion fetchByR_S_First(long recordId, int status, OrderByComparator<DDLRecordVersion> orderByComparator) {
        List<DDLRecordVersion> list = this.findByR_S(recordId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecordVersion findByR_S_Last(long recordId, int status, OrderByComparator<DDLRecordVersion> orderByComparator) throws NoSuchRecordVersionException {
        DDLRecordVersion ddlRecordVersion = this.fetchByR_S_Last(recordId, status, orderByComparator);
        if (ddlRecordVersion != null) {
            return ddlRecordVersion;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("recordId=");
        msg.append(recordId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchRecordVersionException(msg.toString());
    }

    public DDLRecordVersion fetchByR_S_Last(long recordId, int status, OrderByComparator<DDLRecordVersion> orderByComparator) {
        int count = this.countByR_S(recordId, status);
        if (count == 0) {
            return null;
        }
        List<DDLRecordVersion> list = this.findByR_S(recordId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DDLRecordVersion[] findByR_S_PrevAndNext(long recordVersionId, long recordId, int status, OrderByComparator<DDLRecordVersion> orderByComparator) throws NoSuchRecordVersionException {
        DDLRecordVersion ddlRecordVersion = this.findByPrimaryKey(recordVersionId);
        Session session = null;
        try {
            session = this.openSession();
            DDLRecordVersion[] array = new DDLRecordVersionImpl[]{this.getByR_S_PrevAndNext(session, ddlRecordVersion, recordId, status, orderByComparator, true), ddlRecordVersion, this.getByR_S_PrevAndNext(session, ddlRecordVersion, recordId, status, orderByComparator, false)};
            DDLRecordVersion[] dDLRecordVersionArray = array;
            return dDLRecordVersionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDLRecordVersion getByR_S_PrevAndNext(Session session, DDLRecordVersion ddlRecordVersion, long recordId, int status, OrderByComparator<DDLRecordVersion> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_DDLRECORDVERSION_WHERE);
        query.append("ddlRecordVersion.recordId = ? AND ");
        query.append(_FINDER_COLUMN_R_S_STATUS_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ddlRecordVersion.recordVersionId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(recordId);
        qPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ddlRecordVersion)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (DDLRecordVersion)list.get(1);
        }
        return null;
    }

    public void removeByR_S(long recordId, int status) {
        for (DDLRecordVersion ddlRecordVersion : this.findByR_S(recordId, status, -1, -1, null)) {
            this.remove((BaseModel)ddlRecordVersion);
        }
    }

    public int countByR_S(long recordId, int status) {
        FinderPath finderPath = this._finderPathCountByR_S;
        Object[] finderArgs = new Object[]{recordId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_DDLRECORDVERSION_WHERE);
            query.append("ddlRecordVersion.recordId = ? AND ");
            query.append(_FINDER_COLUMN_R_S_STATUS_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(recordId);
                qPos.add(status);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DDLRecordVersionPersistenceImpl() {
        this.setModelClass(DDLRecordVersion.class);
    }

    public void cacheResult(DDLRecordVersion ddlRecordVersion) {
        this.entityCache.putResult(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionImpl.class, (Serializable)Long.valueOf(ddlRecordVersion.getPrimaryKey()), (Serializable)ddlRecordVersion);
        this.finderCache.putResult(this._finderPathFetchByR_V, new Object[]{ddlRecordVersion.getRecordId(), ddlRecordVersion.getVersion()}, (Object)ddlRecordVersion);
        ddlRecordVersion.resetOriginalValues();
    }

    public void cacheResult(List<DDLRecordVersion> ddlRecordVersions) {
        for (DDLRecordVersion ddlRecordVersion : ddlRecordVersions) {
            if (this.entityCache.getResult(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionImpl.class, (Serializable)Long.valueOf(ddlRecordVersion.getPrimaryKey())) == null) {
                this.cacheResult(ddlRecordVersion);
                continue;
            }
            ddlRecordVersion.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(DDLRecordVersionImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(DDLRecordVersion ddlRecordVersion) {
        this.entityCache.removeResult(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionImpl.class, (Serializable)Long.valueOf(ddlRecordVersion.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((DDLRecordVersionModelImpl)ddlRecordVersion, true);
    }

    public void clearCache(List<DDLRecordVersion> ddlRecordVersions) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (DDLRecordVersion ddlRecordVersion : ddlRecordVersions) {
            this.entityCache.removeResult(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionImpl.class, (Serializable)Long.valueOf(ddlRecordVersion.getPrimaryKey()));
            this.clearUniqueFindersCache((DDLRecordVersionModelImpl)ddlRecordVersion, true);
        }
    }

    protected void cacheUniqueFindersCache(DDLRecordVersionModelImpl ddlRecordVersionModelImpl) {
        Object[] args = new Object[]{ddlRecordVersionModelImpl.getRecordId(), ddlRecordVersionModelImpl.getVersion()};
        this.finderCache.putResult(this._finderPathCountByR_V, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByR_V, args, (Object)ddlRecordVersionModelImpl, false);
    }

    protected void clearUniqueFindersCache(DDLRecordVersionModelImpl ddlRecordVersionModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{ddlRecordVersionModelImpl.getRecordId(), ddlRecordVersionModelImpl.getVersion()};
            this.finderCache.removeResult(this._finderPathCountByR_V, args);
            this.finderCache.removeResult(this._finderPathFetchByR_V, args);
        }
        if ((ddlRecordVersionModelImpl.getColumnBitmask() & this._finderPathFetchByR_V.getColumnBitmask()) != 0L) {
            args = new Object[]{ddlRecordVersionModelImpl.getOriginalRecordId(), ddlRecordVersionModelImpl.getOriginalVersion()};
            this.finderCache.removeResult(this._finderPathCountByR_V, args);
            this.finderCache.removeResult(this._finderPathFetchByR_V, args);
        }
    }

    public DDLRecordVersion create(long recordVersionId) {
        DDLRecordVersionImpl ddlRecordVersion = new DDLRecordVersionImpl();
        ddlRecordVersion.setNew(true);
        ddlRecordVersion.setPrimaryKey(recordVersionId);
        ddlRecordVersion.setCompanyId(CompanyThreadLocal.getCompanyId());
        return ddlRecordVersion;
    }

    public DDLRecordVersion remove(long recordVersionId) throws NoSuchRecordVersionException {
        return this.remove(Long.valueOf(recordVersionId));
    }

    public DDLRecordVersion remove(Serializable primaryKey) throws NoSuchRecordVersionException {
        Session session = null;
        try {
            session = this.openSession();
            DDLRecordVersion ddlRecordVersion = (DDLRecordVersion)session.get(DDLRecordVersionImpl.class, primaryKey);
            if (ddlRecordVersion == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchRecordVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            DDLRecordVersion dDLRecordVersion = (DDLRecordVersion)this.remove((BaseModel)ddlRecordVersion);
            return dDLRecordVersion;
        }
        catch (NoSuchRecordVersionException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DDLRecordVersion removeImpl(DDLRecordVersion ddlRecordVersion) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ddlRecordVersion)) {
                ddlRecordVersion = (DDLRecordVersion)session.get(DDLRecordVersionImpl.class, ddlRecordVersion.getPrimaryKeyObj());
            }
            if (ddlRecordVersion != null) {
                session.delete((Object)ddlRecordVersion);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (ddlRecordVersion != null) {
            this.clearCache(ddlRecordVersion);
        }
        return ddlRecordVersion;
    }

    public DDLRecordVersion updateImpl(DDLRecordVersion ddlRecordVersion) {
        boolean isNew = ddlRecordVersion.isNew();
        if (!(ddlRecordVersion instanceof DDLRecordVersionModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ddlRecordVersion.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)ddlRecordVersion);
                throw new IllegalArgumentException("Implement ModelWrapper in ddlRecordVersion proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom DDLRecordVersion implementation " + ddlRecordVersion.getClass());
        }
        DDLRecordVersionModelImpl ddlRecordVersionModelImpl = (DDLRecordVersionModelImpl)ddlRecordVersion;
        Session session = null;
        try {
            session = this.openSession();
            if (ddlRecordVersion.isNew()) {
                session.save((Object)ddlRecordVersion);
                ddlRecordVersion.setNew(false);
            } else {
                ddlRecordVersion = (DDLRecordVersion)session.merge((Object)ddlRecordVersion);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!DDLRecordVersionModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{ddlRecordVersionModelImpl.getRecordId()};
            this.finderCache.removeResult(this._finderPathCountByRecordId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByRecordId, args);
            args = new Object[]{ddlRecordVersionModelImpl.getRecordId(), ddlRecordVersionModelImpl.getStatus()};
            this.finderCache.removeResult(this._finderPathCountByR_S, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByR_S, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((ddlRecordVersionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByRecordId.getColumnBitmask()) != 0L) {
                args = new Object[]{ddlRecordVersionModelImpl.getOriginalRecordId()};
                this.finderCache.removeResult(this._finderPathCountByRecordId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByRecordId, args);
                args = new Object[]{ddlRecordVersionModelImpl.getRecordId()};
                this.finderCache.removeResult(this._finderPathCountByRecordId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByRecordId, args);
            }
            if ((ddlRecordVersionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByR_S.getColumnBitmask()) != 0L) {
                args = new Object[]{ddlRecordVersionModelImpl.getOriginalRecordId(), ddlRecordVersionModelImpl.getOriginalStatus()};
                this.finderCache.removeResult(this._finderPathCountByR_S, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByR_S, args);
                args = new Object[]{ddlRecordVersionModelImpl.getRecordId(), ddlRecordVersionModelImpl.getStatus()};
                this.finderCache.removeResult(this._finderPathCountByR_S, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByR_S, args);
            }
        }
        this.entityCache.putResult(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionImpl.class, (Serializable)Long.valueOf(ddlRecordVersion.getPrimaryKey()), (Serializable)ddlRecordVersion, false);
        this.clearUniqueFindersCache(ddlRecordVersionModelImpl, false);
        this.cacheUniqueFindersCache(ddlRecordVersionModelImpl);
        ddlRecordVersion.resetOriginalValues();
        return ddlRecordVersion;
    }

    public DDLRecordVersion findByPrimaryKey(Serializable primaryKey) throws NoSuchRecordVersionException {
        DDLRecordVersion ddlRecordVersion = this.fetchByPrimaryKey(primaryKey);
        if (ddlRecordVersion == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchRecordVersionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ddlRecordVersion;
    }

    public DDLRecordVersion findByPrimaryKey(long recordVersionId) throws NoSuchRecordVersionException {
        return this.findByPrimaryKey(Long.valueOf(recordVersionId));
    }

    public DDLRecordVersion fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        DDLRecordVersion ddlRecordVersion = (DDLRecordVersion)serializable;
        if (ddlRecordVersion == null) {
            Session session = null;
            try {
                session = this.openSession();
                ddlRecordVersion = (DDLRecordVersion)session.get(DDLRecordVersionImpl.class, primaryKey);
                if (ddlRecordVersion != null) {
                    this.cacheResult(ddlRecordVersion);
                } else {
                    this.entityCache.putResult(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return ddlRecordVersion;
    }

    public DDLRecordVersion fetchByPrimaryKey(long recordVersionId) {
        return this.fetchByPrimaryKey(Long.valueOf(recordVersionId));
    }

    public Map<Serializable, DDLRecordVersion> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, DDLRecordVersion> map = new HashMap<Serializable, DDLRecordVersion>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            DDLRecordVersion dDLRecordVersion = this.fetchByPrimaryKey(primaryKey);
            if (dDLRecordVersion != null) {
                map.put(primaryKey, dDLRecordVersion);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (DDLRecordVersion)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_DDLRECORDVERSION_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (DDLRecordVersion dDLRecordVersion : q.list()) {
                map.put(dDLRecordVersion.getPrimaryKeyObj(), dDLRecordVersion);
                this.cacheResult(dDLRecordVersion);
                uncachedPrimaryKeys.remove(dDLRecordVersion.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<DDLRecordVersion> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<DDLRecordVersion> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<DDLRecordVersion> findAll(int start, int end, OrderByComparator<DDLRecordVersion> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<DDLRecordVersion> findAll(int start, int end, OrderByComparator<DDLRecordVersion> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_DDLRECORDVERSION);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_DDLRECORDVERSION;
                if (pagination) {
                    sql = sql.concat(" ORDER BY ddlRecordVersion.recordVersionId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (DDLRecordVersion ddlRecordVersion : this.findAll()) {
            this.remove((BaseModel)ddlRecordVersion);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_DDLRECORDVERSION);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return DDLRecordVersionModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionModelImpl.FINDER_CACHE_ENABLED, DDLRecordVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionModelImpl.FINDER_CACHE_ENABLED, DDLRecordVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByRecordId = new FinderPath(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionModelImpl.FINDER_CACHE_ENABLED, DDLRecordVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByRecordId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByRecordId = new FinderPath(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionModelImpl.FINDER_CACHE_ENABLED, DDLRecordVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByRecordId", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByRecordId = new FinderPath(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByRecordId", new String[]{Long.class.getName()});
        this._finderPathFetchByR_V = new FinderPath(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionModelImpl.FINDER_CACHE_ENABLED, DDLRecordVersionImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByR_V", new String[]{Long.class.getName(), String.class.getName()}, 5L);
        this._finderPathCountByR_V = new FinderPath(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByR_V", new String[]{Long.class.getName(), String.class.getName()});
        this._finderPathWithPaginationFindByR_S = new FinderPath(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionModelImpl.FINDER_CACHE_ENABLED, DDLRecordVersionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByR_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByR_S = new FinderPath(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionModelImpl.FINDER_CACHE_ENABLED, DDLRecordVersionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByR_S", new String[]{Long.class.getName(), Integer.class.getName()}, 3L);
        this._finderPathCountByR_S = new FinderPath(DDLRecordVersionModelImpl.ENTITY_CACHE_ENABLED, DDLRecordVersionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByR_S", new String[]{Long.class.getName(), Integer.class.getName()});
    }

    public void destroy() {
        this.entityCache.removeCache(DDLRecordVersionImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

