/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.impl;

import com.liferay.dynamic.data.lists.exception.RecordSetDDMStructureIdException;
import com.liferay.dynamic.data.lists.exception.RecordSetDuplicateRecordSetKeyException;
import com.liferay.dynamic.data.lists.exception.RecordSetNameException;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordSetSettings;
import com.liferay.dynamic.data.lists.service.base.DDLRecordSetLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLink;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormInstanceFactory;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDLRecordSetLocalServiceImpl
extends DDLRecordSetLocalServiceBaseImpl {
    @ServiceReference(type=DDMFormValuesJSONDeserializer.class)
    protected DDMFormValuesJSONDeserializer ddmFormValuesJSONDeserializer;
    @ServiceReference(type=DDMFormValuesJSONSerializer.class)
    protected DDMFormValuesJSONSerializer ddmFormValuesJSONSerializer;
    @ServiceReference(type=DDMFormValuesValidator.class)
    protected DDMFormValuesValidator ddmFormValuesValidator;
    @ServiceReference(type=DDMStructureLinkLocalService.class)
    protected DDMStructureLinkLocalService ddmStructureLinkLocalService;
    @ServiceReference(type=DDMStructureLocalService.class)
    protected DDMStructureLocalService ddmStructureLocalService;

    public DDLRecordSet addRecordSet(long userId, long groupId, long ddmStructureId, String recordSetKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, int scope, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        if (Validator.isNull((String)recordSetKey)) {
            recordSetKey = String.valueOf(this.counterLocalService.increment());
        }
        this.validate(groupId, ddmStructureId, recordSetKey, nameMap);
        long recordSetId = this.counterLocalService.increment();
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.create(recordSetId);
        recordSet.setUuid(serviceContext.getUuid());
        recordSet.setGroupId(groupId);
        recordSet.setCompanyId(user.getCompanyId());
        recordSet.setUserId(user.getUserId());
        recordSet.setUserName(user.getFullName());
        recordSet.setDDMStructureId(ddmStructureId);
        recordSet.setRecordSetKey(recordSetKey);
        recordSet.setNameMap(nameMap);
        recordSet.setDescriptionMap(descriptionMap);
        recordSet.setMinDisplayRows(minDisplayRows);
        recordSet.setScope(scope);
        this.ddlRecordSetPersistence.update((BaseModel)recordSet);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addRecordSetResources(recordSet, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addRecordSetResources(recordSet, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        long classNameId = this.classNameLocalService.getClassNameId(DDLRecordSet.class);
        this.ddmStructureLinkLocalService.addStructureLink(classNameId, recordSetId, ddmStructureId);
        return recordSet;
    }

    public void addRecordSetResources(DDLRecordSet recordSet, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(recordSet.getCompanyId(), recordSet.getGroupId(), recordSet.getUserId(), DDLRecordSet.class.getName(), recordSet.getRecordSetId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addRecordSetResources(DDLRecordSet recordSet, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(recordSet.getCompanyId(), recordSet.getGroupId(), recordSet.getUserId(), DDLRecordSet.class.getName(), recordSet.getRecordSetId(), groupPermissions, guestPermissions);
    }

    @SystemEvent(action=1, type=1)
    public void deleteRecordSet(DDLRecordSet recordSet) throws PortalException {
        this.ddlRecordSetPersistence.remove((BaseModel)recordSet);
        this.resourceLocalService.deleteResource(recordSet.getCompanyId(), DDLRecordSet.class.getName(), 4, recordSet.getRecordSetId());
        this.ddlRecordLocalService.deleteRecords(recordSet.getRecordSetId());
        this.ddmStructureLinkLocalService.deleteStructureLinks(this.classNameLocalService.getClassNameId(DDLRecordSet.class), recordSet.getRecordSetId());
        this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(recordSet.getCompanyId(), recordSet.getGroupId(), DDLRecordSet.class.getName(), recordSet.getRecordSetId(), 0L);
    }

    public void deleteRecordSet(long recordSetId) throws PortalException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        this.ddlRecordSetLocalService.deleteRecordSet(recordSet);
    }

    public void deleteRecordSet(long groupId, String recordSetKey) throws PortalException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByG_R(groupId, recordSetKey);
        this.ddlRecordSetLocalService.deleteRecordSet(recordSet);
    }

    public void deleteRecordSets(long groupId) throws PortalException {
        List recordSets = this.ddlRecordSetPersistence.findByGroupId(groupId);
        for (DDLRecordSet recordSet : recordSets) {
            this.ddlRecordSetLocalService.deleteRecordSet(recordSet);
        }
    }

    public DDLRecordSet fetchRecordSet(long recordSetId) {
        return this.ddlRecordSetPersistence.fetchByPrimaryKey(recordSetId);
    }

    public DDLRecordSet fetchRecordSet(long groupId, String recordSetKey) {
        return this.ddlRecordSetPersistence.fetchByG_R(groupId, recordSetKey);
    }

    public DDLRecordSet getRecordSet(long recordSetId) throws PortalException {
        return this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
    }

    public DDLRecordSet getRecordSet(long groupId, String recordSetKey) throws PortalException {
        return this.ddlRecordSetPersistence.findByG_R(groupId, recordSetKey);
    }

    public List<DDLRecordSet> getRecordSets(long groupId) {
        return this.ddlRecordSetPersistence.findByGroupId(groupId);
    }

    public int getRecordSetsCount(long groupId) {
        return this.ddlRecordSetPersistence.countByGroupId(groupId);
    }

    public DDMFormValues getRecordSetSettingsDDMFormValues(DDLRecordSet recordSet) throws PortalException {
        DDMForm ddmForm = DDMFormFactory.create(DDLRecordSetSettings.class);
        return this.ddmFormValuesJSONDeserializer.deserialize(ddmForm, recordSet.getSettings());
    }

    public DDLRecordSetSettings getRecordSetSettingsModel(DDLRecordSet recordSet) throws PortalException {
        DDMFormValues ddmFormValues = this.getRecordSetSettingsDDMFormValues(recordSet);
        return (DDLRecordSetSettings)DDMFormInstanceFactory.create(DDLRecordSetSettings.class, (DDMFormValues)ddmFormValues);
    }

    public List<DDLRecordSet> search(long companyId, long groupId, String keywords, int scope, int start, int end, OrderByComparator<DDLRecordSet> orderByComparator) {
        return this.ddlRecordSetFinder.findByKeywords(companyId, groupId, keywords, scope, start, end, orderByComparator);
    }

    public List<DDLRecordSet> search(long companyId, long groupId, String name, String description, int scope, boolean andOperator, int start, int end, OrderByComparator<DDLRecordSet> orderByComparator) {
        return this.ddlRecordSetFinder.findByC_G_N_D_S(companyId, groupId, name, description, scope, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long groupId, String keywords, int scope) {
        return this.ddlRecordSetFinder.countByKeywords(companyId, groupId, keywords, scope);
    }

    public int searchCount(long companyId, long groupId, String name, String description, int scope, boolean andOperator) {
        return this.ddlRecordSetFinder.countByC_G_N_D_S(companyId, groupId, name, description, scope, andOperator);
    }

    public DDLRecordSet updateMinDisplayRows(long recordSetId, int minDisplayRows, ServiceContext serviceContext) throws PortalException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        recordSet.setMinDisplayRows(minDisplayRows);
        this.ddlRecordSetPersistence.update((BaseModel)recordSet);
        return recordSet;
    }

    public DDLRecordSet updateRecordSet(long recordSetId, DDMFormValues settingsDDMFormValues) throws PortalException {
        Date now = new Date();
        this.ddmFormValuesValidator.validate(settingsDDMFormValues);
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        recordSet.setModifiedDate(now);
        recordSet.setSettings(this.ddmFormValuesJSONSerializer.serialize(settingsDDMFormValues));
        return (DDLRecordSet)this.ddlRecordSetPersistence.update((BaseModel)recordSet);
    }

    public DDLRecordSet updateRecordSet(long recordSetId, long ddmStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, ServiceContext serviceContext) throws PortalException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        return this.doUpdateRecordSet(ddmStructureId, nameMap, descriptionMap, minDisplayRows, serviceContext, recordSet);
    }

    public DDLRecordSet updateRecordSet(long groupId, long ddmStructureId, String recordSetKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, ServiceContext serviceContext) throws PortalException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByG_R(groupId, recordSetKey);
        return this.doUpdateRecordSet(ddmStructureId, nameMap, descriptionMap, minDisplayRows, serviceContext, recordSet);
    }

    protected DDLRecordSet doUpdateRecordSet(long ddmStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, ServiceContext serviceContext, DDLRecordSet recordSet) throws PortalException {
        this.validateDDMStructureId(ddmStructureId);
        this.validateName(nameMap);
        long oldDDMStructureId = recordSet.getDDMStructureId();
        recordSet.setDDMStructureId(ddmStructureId);
        recordSet.setNameMap(nameMap);
        recordSet.setDescriptionMap(descriptionMap);
        recordSet.setMinDisplayRows(minDisplayRows);
        this.ddlRecordSetPersistence.update((BaseModel)recordSet);
        if (oldDDMStructureId != ddmStructureId) {
            this.ddlRecordLocalService.deleteRecords(recordSet.getRecordSetId());
            long classNameId = this.classNameLocalService.getClassNameId(DDLRecordSet.class);
            DDMStructureLink ddmStructureLink = this.ddmStructureLinkLocalService.getUniqueStructureLink(classNameId, recordSet.getRecordSetId());
            this.ddmStructureLinkLocalService.updateStructureLink(ddmStructureLink.getStructureLinkId(), classNameId, recordSet.getRecordSetId(), ddmStructureId);
        }
        return recordSet;
    }

    protected void validate(long groupId, long ddmStructureId, String recordSetKey, Map<Locale, String> nameMap) throws PortalException {
        DDLRecordSet recordSet;
        this.validateDDMStructureId(ddmStructureId);
        if (Validator.isNotNull((String)recordSetKey) && (recordSet = this.ddlRecordSetPersistence.fetchByG_R(groupId, recordSetKey)) != null) {
            RecordSetDuplicateRecordSetKeyException rsdrske = new RecordSetDuplicateRecordSetKeyException();
            rsdrske.setRecordSetKey(recordSet.getRecordSetKey());
            throw rsdrske;
        }
        this.validateName(nameMap);
    }

    protected void validateDDMStructureId(long ddmStructureId) throws PortalException {
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(ddmStructureId);
        if (ddmStructure == null) {
            throw new RecordSetDDMStructureIdException("No DDM structure exists with the DDM structure ID " + ddmStructureId);
        }
    }

    protected void validateName(Map<Locale, String> nameMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        String name = nameMap.get(locale);
        if (Validator.isNull((String)name)) {
            throw new RecordSetNameException("Name is null for locale " + locale.getDisplayName());
        }
    }
}

