/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.exporter.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.dynamic.data.lists.exporter.DDLExporter;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

@ProviderType
public abstract class BaseDDLExporter
implements DDLExporter {
    private Locale _locale;

    public byte[] export(long recordSetId) throws Exception {
        return this.doExport(recordSetId, -1, -1, -1, null);
    }

    public byte[] export(long recordSetId, int status) throws Exception {
        return this.doExport(recordSetId, status, -1, -1, null);
    }

    public byte[] export(long recordSetId, int status, int start, int end) throws Exception {
        return this.doExport(recordSetId, status, start, end, null);
    }

    public byte[] export(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) throws Exception {
        return this.doExport(recordSetId, status, start, end, orderByComparator);
    }

    public Locale getLocale() {
        if (this._locale == null) {
            this._locale = LocaleUtil.getSiteDefault();
        }
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    protected abstract byte[] doExport(long var1, int var3, int var4, int var5, OrderByComparator<DDLRecord> var6) throws Exception;

    protected String formatDate(Date date, DateTimeFormatter dateTimeFormatter) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return dateTimeFormatter.format(localDateTime);
    }

    protected DateTimeFormatter getDateTimeFormatter() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT);
        return dateTimeFormatter.withLocale(this.getLocale());
    }

    protected List<DDMFormField> getDDMFormFields(DDMStructure ddmStructure) throws Exception {
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>();
        for (DDMFormField ddmFormField : ddmStructure.getDDMFormFields(false)) {
            ddmFormFields.add(ddmFormField);
        }
        return ddmFormFields;
    }

    protected String getStatusMessage(int status) {
        String statusLabel = WorkflowConstants.getStatusLabel((int)status);
        return LanguageUtil.get((Locale)this._locale, (String)statusLabel);
    }
}

