/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.permission;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalServiceUtil;
import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;

public class DDLRecordSetPermission {
    public static void check(PermissionChecker permissionChecker, DDLRecordSet recordSet, String actionId) throws PortalException {
        if (!DDLRecordSetPermission.contains(permissionChecker, recordSet, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DDLRecordSet.class.getName(), recordSet.getRecordSetId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long recordSetId, String actionId) throws PortalException {
        if (!DDLRecordSetPermission.contains(permissionChecker, recordSetId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DDLRecordSet.class.getName(), recordSetId, new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String recordSetKey, String actionId) throws PortalException {
        DDLRecordSet recordSet = DDLRecordSetLocalServiceUtil.getRecordSet((long)groupId, (String)recordSetKey);
        DDLRecordSetPermission.check(permissionChecker, recordSet, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, DDLRecordSet recordSet, String actionId) {
        String portletId = PortletProviderUtil.getPortletId((String)DDLRecord.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)recordSet.getGroupId(), (String)DDLRecordSet.class.getName(), (long)recordSet.getRecordSetId(), (String)portletId, (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(recordSet.getCompanyId(), DDLRecordSet.class.getName(), recordSet.getRecordSetId(), recordSet.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(recordSet.getGroupId(), DDLRecordSet.class.getName(), recordSet.getRecordSetId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long recordSetId, String actionId) throws PortalException {
        DDLRecordSet recordSet = DDLRecordSetLocalServiceUtil.getRecordSet((long)recordSetId);
        return DDLRecordSetPermission.contains(permissionChecker, recordSet, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String recordSetKey, String actionId) throws PortalException {
        DDLRecordSet recordSet = DDLRecordSetLocalServiceUtil.getRecordSet((long)groupId, (String)recordSetKey);
        return DDLRecordSetPermission.contains(permissionChecker, recordSet, actionId);
    }
}

