/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.impl;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.base.DDLRecordSetServiceBaseImpl;
import com.liferay.dynamic.data.lists.service.permission.DDLPermission;
import com.liferay.dynamic.data.lists.service.permission.DDLRecordSetPermission;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDLRecordSetServiceImpl
extends DDLRecordSetServiceBaseImpl {
    public DDLRecordSet addRecordSet(long groupId, long ddmStructureId, String recordSetKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, int scope, ServiceContext serviceContext) throws PortalException {
        DDLPermission.check(this.getPermissionChecker(), groupId, "ADD_RECORD_SET");
        return this.ddlRecordSetLocalService.addRecordSet(this.getUserId(), groupId, ddmStructureId, recordSetKey, nameMap, descriptionMap, minDisplayRows, scope, serviceContext);
    }

    public void deleteRecordSet(long recordSetId) throws PortalException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSetId, "DELETE");
        this.ddlRecordSetLocalService.deleteRecordSet(recordSetId);
    }

    public DDLRecordSet fetchRecordSet(long recordSetId) throws PortalException {
        DDLRecordSet recordSet = this.ddlRecordSetLocalService.fetchRecordSet(recordSetId);
        if (recordSet == null) {
            return null;
        }
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSet, "VIEW");
        return recordSet;
    }

    public DDLRecordSet getRecordSet(long recordSetId) throws PortalException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSetId, "VIEW");
        return this.ddlRecordSetLocalService.getRecordSet(recordSetId);
    }

    public List<DDLRecordSet> getRecordSets(long[] groupIds) {
        return this.ddlRecordSetPersistence.filterFindByGroupId(groupIds);
    }

    public List<DDLRecordSet> search(long companyId, long groupId, String keywords, int scope, int start, int end, OrderByComparator<DDLRecordSet> orderByComparator) {
        return this.ddlRecordSetFinder.filterFindByKeywords(companyId, groupId, keywords, scope, start, end, orderByComparator);
    }

    public List<DDLRecordSet> search(long companyId, long groupId, String name, String description, int scope, boolean andOperator, int start, int end, OrderByComparator<DDLRecordSet> orderByComparator) {
        return this.ddlRecordSetFinder.filterFindByC_G_N_D_S(companyId, groupId, name, description, scope, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long groupId, String keywords, int scope) {
        return this.ddlRecordSetFinder.filterCountByKeywords(companyId, groupId, keywords, scope);
    }

    public int searchCount(long companyId, long groupId, String name, String description, int scope, boolean andOperator) {
        return this.ddlRecordSetFinder.filterCountByC_G_N_D_S(companyId, groupId, name, description, scope, andOperator);
    }

    public DDLRecordSet updateMinDisplayRows(long recordSetId, int minDisplayRows, ServiceContext serviceContext) throws PortalException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSetId, "UPDATE");
        return this.ddlRecordSetLocalService.updateMinDisplayRows(recordSetId, minDisplayRows, serviceContext);
    }

    public DDLRecordSet updateRecordSet(long recordSetId, DDMFormValues settingsDDMFormValues) throws PortalException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSetId, "UPDATE");
        return this.ddlRecordSetLocalService.updateRecordSet(recordSetId, settingsDDMFormValues);
    }

    public DDLRecordSet updateRecordSet(long recordSetId, long ddmStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, ServiceContext serviceContext) throws PortalException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSetId, "UPDATE");
        return this.ddlRecordSetLocalService.updateRecordSet(recordSetId, ddmStructureId, nameMap, descriptionMap, minDisplayRows, serviceContext);
    }

    public DDLRecordSet updateRecordSet(long groupId, long ddmStructureId, String recordSetKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, ServiceContext serviceContext) throws PortalException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), groupId, recordSetKey, "UPDATE");
        return this.ddlRecordSetLocalService.updateRecordSet(groupId, ddmStructureId, recordSetKey, nameMap, descriptionMap, minDisplayRows, serviceContext);
    }
}

