/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.service.impl;

import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.lists.exception.NoSuchRecordException;
import com.liferay.dynamic.data.lists.model.DDLFormRecord;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordConstants;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.base.DDLRecordLocalServiceBaseImpl;
import com.liferay.dynamic.data.lists.util.DDL;
import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDLRecordLocalServiceImpl
extends DDLRecordLocalServiceBaseImpl {
    @ServiceReference(type=DDM.class)
    protected DDM ddm;
    @ServiceReference(type=DDMFormValuesToFieldsConverter.class)
    protected DDMFormValuesToFieldsConverter ddmFormValuesToFieldsConverter;
    @ServiceReference(type=FieldsToDDMFormValuesConverter.class)
    protected FieldsToDDMFormValuesConverter fieldsToDDMFormValuesConverter;
    @ServiceReference(type=IndexerRegistry.class)
    protected IndexerRegistry indexerRegistry;
    @ServiceReference(type=StorageEngine.class)
    protected StorageEngine storageEngine;
    private static final Log _log = LogFactoryUtil.getLog(DDLRecordLocalServiceImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public DDLRecord addRecord(long userId, long groupId, long recordSetId, int displayIndex, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        long recordId = this.counterLocalService.increment();
        DDLRecord record = this.ddlRecordPersistence.create(recordId);
        record.setUuid(serviceContext.getUuid());
        record.setGroupId(groupId);
        record.setCompanyId(user.getCompanyId());
        record.setUserId(user.getUserId());
        record.setUserName(user.getFullName());
        record.setVersionUserId(user.getUserId());
        record.setVersionUserName(user.getFullName());
        long ddmStorageId = this.storageEngine.create(recordSet.getCompanyId(), recordSet.getDDMStructureId(), ddmFormValues, serviceContext);
        record.setDDMStorageId(ddmStorageId);
        record.setRecordSetId(recordSetId);
        record.setVersion("1.0");
        record.setDisplayIndex(displayIndex);
        this.ddlRecordPersistence.update((BaseModel)record);
        DDLRecordVersion recordVersion = this.addRecordVersion(user, record, ddmStorageId, "1.0", displayIndex, 2);
        Locale locale = serviceContext.getLocale();
        this.updateAsset(userId, record, recordVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), locale, serviceContext.getAssetPriority());
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)this.getWorkflowAssetClassName(recordSet), (long)recordVersion.getRecordVersionId(), (Object)recordVersion, (ServiceContext)serviceContext);
        return record;
    }

    public DDLRecord addRecord(long userId, long groupId, long recordSetId, int displayIndex, Fields fields, ServiceContext serviceContext) throws PortalException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        DDMFormValues ddmFormValues = this.fieldsToDDMFormValuesConverter.convert(recordSet.getDDMStructure(), fields);
        return this.ddlRecordLocalService.addRecord(userId, groupId, recordSetId, displayIndex, ddmFormValues, serviceContext);
    }

    public DDLRecord addRecord(long userId, long groupId, long recordSetId, int displayIndex, Map<String, Serializable> fieldsMap, ServiceContext serviceContext) throws PortalException {
        DDLRecordSet recordSet = this.ddlRecordSetPersistence.findByPrimaryKey(recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Fields fields = this.toFields(ddmStructure.getStructureId(), fieldsMap, serviceContext.getLocale(), LocaleUtil.getSiteDefault(), true);
        return this.ddlRecordLocalService.addRecord(userId, groupId, recordSetId, displayIndex, fields, serviceContext);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public DDLRecord deleteRecord(DDLRecord record) throws PortalException {
        this.ddlRecordPersistence.remove((BaseModel)record);
        List recordVersions = this.ddlRecordVersionPersistence.findByRecordId(record.getRecordId());
        for (DDLRecordVersion recordVersion : recordVersions) {
            this.ddlRecordVersionPersistence.remove((BaseModel)recordVersion);
            this.storageEngine.deleteByClass(recordVersion.getDDMStorageId());
            this.deleteWorkflowInstanceLink(record.getCompanyId(), record.getGroupId(), recordVersion.getPrimaryKey());
        }
        this.deleteAssetEntry(record.getRecordId());
        this.deleteRatingsStats(record.getRecordId());
        return record;
    }

    public void deleteRecord(long recordId) throws PortalException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        this.ddlRecordLocalService.deleteRecord(record);
    }

    public DDLRecord deleteRecordLocale(long recordId, Locale locale, ServiceContext serviceContext) throws PortalException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        DDLRecordSet recordSet = record.getRecordSet();
        DDMFormValues ddmFormValues = this.storageEngine.getDDMFormValues(record.getDDMStorageId());
        Fields fields = this.ddmFormValuesToFieldsConverter.convert(recordSet.getDDMStructure(), ddmFormValues);
        for (Field field : fields) {
            Map valuesMap = field.getValuesMap();
            valuesMap.remove(locale);
        }
        return this.ddlRecordLocalService.updateRecord(serviceContext.getUserId(), recordId, false, 0, fields, false, serviceContext);
    }

    public void deleteRecords(long recordSetId) throws PortalException {
        List records = this.ddlRecordPersistence.findByRecordSetId(recordSetId);
        for (DDLRecord record : records) {
            this.ddlRecordLocalService.deleteRecord(record);
        }
    }

    public DDLRecord fetchRecord(long recordId) {
        return this.ddlRecordPersistence.fetchByPrimaryKey(recordId);
    }

    public List<DDLRecord> getCompanyRecords(long companyId, int status, int scope, int start, int end, OrderByComparator<DDLRecord> orderByComparator) {
        return this.ddlRecordFinder.findByC_S_S(companyId, status, scope, start, end, orderByComparator);
    }

    public int getCompanyRecordsCount(long companyId, int status, int scope) {
        return this.ddlRecordFinder.countByC_S_S(companyId, status, scope);
    }

    public DDMFormValues getDDMFormValues(long ddmStorageId) throws StorageException {
        return this.storageEngine.getDDMFormValues(ddmStorageId);
    }

    @Deprecated
    public DDLRecordVersion getLatestRecordVersion(long recordId) throws PortalException {
        return this.ddlRecordVersionLocalService.getLatestRecordVersion(recordId);
    }

    public Long[] getMinAndMaxCompanyRecordIds(long companyId, int status, int scope) {
        return this.ddlRecordFinder.findByC_S_S_MinAndMax(companyId, status, scope);
    }

    public List<DDLRecord> getMinAndMaxCompanyRecords(long companyId, int status, int scope, long minRecordId, long maxRecordId) {
        return this.ddlRecordFinder.findByC_S_S_MinAndMax(companyId, status, scope, minRecordId, maxRecordId);
    }

    public DDLRecord getRecord(long recordId) throws PortalException {
        return this.ddlRecordPersistence.findByPrimaryKey(recordId);
    }

    public List<DDLRecord> getRecords(long recordSetId) {
        return this.ddlRecordPersistence.findByRecordSetId(recordSetId);
    }

    public List<DDLRecord> getRecords(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) {
        return this.ddlRecordFinder.findByR_S(recordSetId, status, start, end, orderByComparator);
    }

    public List<DDLRecord> getRecords(long recordSetId, long userId) {
        return this.ddlRecordPersistence.findByR_U(recordSetId, userId);
    }

    public int getRecordsCount(long recordSetId, int status) {
        return this.ddlRecordFinder.countByR_S(recordSetId, status);
    }

    @Deprecated
    public DDLRecordVersion getRecordVersion(long recordVersionId) throws PortalException {
        return this.ddlRecordVersionPersistence.findByPrimaryKey(recordVersionId);
    }

    @Deprecated
    public DDLRecordVersion getRecordVersion(long recordId, String version) throws PortalException {
        return this.ddlRecordVersionPersistence.findByR_V(recordId, version);
    }

    @Deprecated
    public List<DDLRecordVersion> getRecordVersions(long recordId, int start, int end, OrderByComparator<DDLRecordVersion> orderByComparator) {
        return this.ddlRecordVersionPersistence.findByRecordId(recordId, start, end, orderByComparator);
    }

    @Deprecated
    public int getRecordVersionsCount(long recordId) {
        return this.ddlRecordVersionPersistence.countByRecordId(recordId);
    }

    public void revertRecord(long userId, long recordId, String version, ServiceContext serviceContext) throws PortalException {
        DDLRecordVersion recordVersion = this.ddlRecordVersionLocalService.getRecordVersion(recordId, version);
        if (!recordVersion.isApproved()) {
            return;
        }
        DDMFormValues ddmFormValues = this.storageEngine.getDDMFormValues(recordVersion.getDDMStorageId());
        serviceContext.setCommand("revert");
        this.ddlRecordLocalService.updateRecord(userId, recordId, true, recordVersion.getDisplayIndex(), ddmFormValues, serviceContext);
    }

    @Deprecated
    public void revertRecordVersion(long userId, long recordId, String version, ServiceContext serviceContext) throws PortalException {
        this.revertRecord(userId, recordId, version, serviceContext);
    }

    public Hits search(SearchContext searchContext) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DDLRecord.class);
            return indexer.search(searchContext);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public BaseModelSearchResult<DDLRecord> searchDDLRecords(SearchContext searchContext) {
        try {
            Indexer<DDLRecord> indexer = this.getDDLRecordIndexer();
            Hits hits = indexer.search(searchContext, DDL.SELECTED_FIELD_NAMES);
            List<DDLRecord> records = this.getRecords(hits);
            return new BaseModelSearchResult(records, hits.getLength());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void updateAsset(long userId, DDLRecord record, DDLRecordVersion recordVersion, long[] assetCategoryIds, String[] assetTagNames, Locale locale, Double priority) throws PortalException {
        DDLRecordSet recordSet = record.getRecordSet();
        int scope = recordSet.getScope();
        if (scope != 0 && scope != 2) {
            return;
        }
        boolean addDraftAssetEntry = false;
        boolean visible = true;
        if (recordVersion != null && !recordVersion.isApproved()) {
            int approvedRecordVersionsCount;
            String version = recordVersion.getVersion();
            if (!version.equals("1.0") && (approvedRecordVersionsCount = this.ddlRecordVersionPersistence.countByR_S(record.getRecordId(), 0)) > 0) {
                addDraftAssetEntry = true;
            }
            visible = false;
        }
        if (scope == 2) {
            visible = false;
        }
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        String ddmStructureName = ddmStructure.getName(locale);
        String recordSetName = recordSet.getName(locale);
        String title = LanguageUtil.format((Locale)locale, (String)"new-x-for-list-x", (Object[])new Object[]{ddmStructureName, recordSetName}, (boolean)false);
        if (addDraftAssetEntry) {
            this.assetEntryLocalService.updateEntry(userId, record.getGroupId(), record.getCreateDate(), record.getModifiedDate(), DDLRecordConstants.getClassName((int)scope), recordVersion.getRecordVersionId(), record.getUuid(), 0L, assetCategoryIds, assetTagNames, true, false, null, null, null, "text/html", title, null, "", null, null, 0, 0, priority);
        } else {
            this.assetEntryLocalService.updateEntry(userId, record.getGroupId(), record.getCreateDate(), record.getModifiedDate(), DDLRecordConstants.getClassName((int)scope), record.getRecordId(), record.getUuid(), 0L, assetCategoryIds, assetTagNames, true, visible, null, null, null, "text/html", title, null, "", null, null, 0, 0, priority);
        }
    }

    public DDLRecord updateRecord(long userId, long recordId, boolean majorVersion, int displayIndex, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        record.setModifiedDate(serviceContext.getModifiedDate(null));
        this.ddlRecordPersistence.update((BaseModel)record);
        DDLRecordVersion recordVersion = record.getLatestRecordVersion();
        if (recordVersion.isApproved()) {
            DDLRecordSet recordSet = record.getRecordSet();
            long ddmStorageId = this.storageEngine.create(recordSet.getCompanyId(), recordSet.getDDMStructureId(), ddmFormValues, serviceContext);
            String version = this.getNextVersion(recordVersion.getVersion(), majorVersion, serviceContext.getWorkflowAction());
            recordVersion = this.addRecordVersion(user, record, ddmStorageId, version, displayIndex, 2);
        } else {
            this.storageEngine.update(recordVersion.getDDMStorageId(), ddmFormValues, serviceContext);
            String version = recordVersion.getVersion();
            this.updateRecordVersion(user, recordVersion, version, displayIndex, recordVersion.getStatus(), serviceContext);
        }
        if (this.isKeepRecordVersionLabel(record.getRecordVersion(), recordVersion, serviceContext)) {
            this.ddlRecordVersionPersistence.remove((BaseModel)recordVersion);
            this.storageEngine.deleteByClass(recordVersion.getDDMStorageId());
            return record;
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)record.getGroupId(), (long)userId, (String)DDLRecord.class.getName(), (long)recordVersion.getRecordVersionId(), (Object)recordVersion, (ServiceContext)serviceContext);
        return record;
    }

    public DDLRecord updateRecord(long userId, long recordId, boolean majorVersion, int displayIndex, Fields fields, boolean mergeFields, ServiceContext serviceContext) throws PortalException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        DDLRecordSet recordSet = record.getRecordSet();
        DDLRecordVersion recordVersion = record.getLatestRecordVersion();
        if (mergeFields) {
            DDMFormValues existingDDMFormValues = this.storageEngine.getDDMFormValues(recordVersion.getDDMStorageId());
            Fields existingFields = this.ddmFormValuesToFieldsConverter.convert(recordSet.getDDMStructure(), existingDDMFormValues);
            fields = this.ddm.mergeFields(fields, existingFields);
        }
        DDMFormValues ddmFormValues = this.fieldsToDDMFormValuesConverter.convert(recordSet.getDDMStructure(), fields);
        return this.ddlRecordLocalService.updateRecord(userId, recordId, majorVersion, displayIndex, ddmFormValues, serviceContext);
    }

    public DDLRecord updateRecord(long userId, long recordId, int displayIndex, Map<String, Serializable> fieldsMap, boolean mergeFields, ServiceContext serviceContext) throws PortalException {
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordId);
        DDMFormValues oldDDMFormValues = record.getDDMFormValues();
        DDLRecordSet recordSet = record.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Fields fields = this.toFields(ddmStructure.getStructureId(), fieldsMap, serviceContext.getLocale(), oldDDMFormValues.getDefaultLocale(), false);
        return this.ddlRecordLocalService.updateRecord(userId, recordId, false, displayIndex, fields, mergeFields, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDLRecord updateStatus(long userId, long recordVersionId, int status, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DDLRecordVersion recordVersion = this.ddlRecordVersionPersistence.findByPrimaryKey(recordVersionId);
        recordVersion.setStatus(status);
        recordVersion.setStatusByUserId(user.getUserId());
        recordVersion.setStatusByUserName(user.getFullName());
        recordVersion.setStatusDate(new Date());
        this.ddlRecordVersionPersistence.update((BaseModel)recordVersion);
        DDLRecord record = this.ddlRecordPersistence.findByPrimaryKey(recordVersion.getRecordId());
        if (status == 0) {
            if (DLUtil.compareVersions((String)record.getVersion(), (String)recordVersion.getVersion()) <= 0) {
                record.setDDMStorageId(recordVersion.getDDMStorageId());
                record.setVersion(recordVersion.getVersion());
                record.setRecordSetId(recordVersion.getRecordSetId());
                record.setDisplayIndex(recordVersion.getDisplayIndex());
                record.setVersion(recordVersion.getVersion());
                record.setVersionUserId(recordVersion.getUserId());
                record.setVersionUserName(recordVersion.getUserName());
                this.ddlRecordPersistence.update((BaseModel)record);
            }
        } else if (Validator.equals((Object)record.getVersion(), (Object)recordVersion.getVersion())) {
            String newVersion = "1.0";
            List approvedRecordVersions = this.ddlRecordVersionPersistence.findByR_S(record.getRecordId(), 0);
            if (!approvedRecordVersions.isEmpty()) {
                newVersion = ((DDLRecordVersion)approvedRecordVersions.get(0)).getVersion();
            }
            record.setVersion(newVersion);
            this.ddlRecordPersistence.update((BaseModel)record);
        }
        Locale locale = serviceContext.getLocale();
        this.updateAsset(userId, record, recordVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), locale, serviceContext.getAssetPriority());
        return record;
    }

    protected DDLRecordVersion addRecordVersion(User user, DDLRecord record, long ddmStorageId, String version, int displayIndex, int status) {
        long recordVersionId = this.counterLocalService.increment();
        DDLRecordVersion recordVersion = this.ddlRecordVersionPersistence.create(recordVersionId);
        recordVersion.setGroupId(record.getGroupId());
        recordVersion.setCompanyId(record.getCompanyId());
        recordVersion.setUserId(user.getUserId());
        recordVersion.setUserName(user.getFullName());
        recordVersion.setCreateDate(record.getModifiedDate());
        recordVersion.setDDMStorageId(ddmStorageId);
        recordVersion.setRecordSetId(record.getRecordSetId());
        recordVersion.setRecordId(record.getRecordId());
        recordVersion.setVersion(version);
        recordVersion.setDisplayIndex(displayIndex);
        recordVersion.setStatus(status);
        recordVersion.setStatusByUserId(user.getUserId());
        recordVersion.setStatusByUserName(user.getFullName());
        recordVersion.setStatusDate(record.getModifiedDate());
        this.ddlRecordVersionPersistence.update((BaseModel)recordVersion);
        return recordVersion;
    }

    protected void deleteAssetEntry(long recordId) throws PortalException {
        this.assetEntryLocalService.deleteEntry(DDLFormRecord.class.getName(), recordId);
        this.assetEntryLocalService.deleteEntry(DDLRecord.class.getName(), recordId);
    }

    protected void deleteRatingsStats(long recordId) throws PortalException {
        this.ratingsStatsLocalService.deleteStats(DDLFormRecord.class.getName(), recordId);
        this.ratingsStatsLocalService.deleteStats(DDLRecord.class.getName(), recordId);
    }

    protected void deleteWorkflowInstanceLink(long companyId, long groupId, long recordVersionId) throws PortalException {
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(companyId, groupId, DDLFormRecord.class.getName(), recordVersionId);
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(companyId, groupId, DDLRecord.class.getName(), recordVersionId);
    }

    protected Indexer<DDLRecord> getDDLRecordIndexer() {
        Indexer indexer = this.indexerRegistry.nullSafeGetIndexer(DDLRecord.class);
        return indexer;
    }

    protected String getNextVersion(String version, boolean majorVersion, int workflowAction) {
        if (workflowAction == 2) {
            majorVersion = false;
        }
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        if (majorVersion) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return versionParts[0] + "." + versionParts[1];
    }

    protected List<DDLRecord> getRecords(Hits hits) throws PortalException {
        ArrayList<DDLRecord> records = new ArrayList<DDLRecord>();
        for (Document document : hits.toList()) {
            long recordId = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                DDLRecord record = this.getRecord(recordId);
                records.add(record);
            }
            catch (NoSuchRecordException nsre) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("DDL record index is stale and contains record " + recordId), (Throwable)nsre);
                }
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                Indexer<DDLRecord> indexer = this.getDDLRecordIndexer();
                indexer.delete(companyId, document.getUID());
            }
        }
        return records;
    }

    protected String getWorkflowAssetClassName(DDLRecordSet recordSet) {
        if (recordSet.getScope() == 2) {
            return DDLFormRecord.class.getName();
        }
        return DDLRecord.class.getName();
    }

    protected boolean isKeepRecordVersionLabel(DDLRecordVersion lastRecordVersion, DDLRecordVersion latestRecordVersion, ServiceContext serviceContext) throws PortalException {
        Map latestAttributes;
        DDMFormValues latestDDMFormValues;
        if (Validator.equals((Object)serviceContext.getCommand(), (Object)"revert")) {
            return false;
        }
        if (serviceContext.getWorkflowAction() == 2) {
            return false;
        }
        if (Validator.equals((Object)lastRecordVersion.getVersion(), (Object)latestRecordVersion.getVersion())) {
            return false;
        }
        DDMFormValues lastDDMFormValues = this.storageEngine.getDDMFormValues(lastRecordVersion.getDDMStorageId());
        if (!lastDDMFormValues.equals((Object)(latestDDMFormValues = this.storageEngine.getDDMFormValues(latestRecordVersion.getDDMStorageId())))) {
            return false;
        }
        ExpandoBridge lastExpandoBridge = lastRecordVersion.getExpandoBridge();
        ExpandoBridge latestExpandoBridge = latestRecordVersion.getExpandoBridge();
        Map lastAttributes = lastExpandoBridge.getAttributes();
        return lastAttributes.equals(latestAttributes = latestExpandoBridge.getAttributes());
    }

    protected Fields toFields(long ddmStructureId, Map<String, Serializable> fieldsMap, Locale locale, Locale defaultLocale, boolean create) {
        Fields fields = new Fields();
        for (Map.Entry<String, Serializable> entry : fieldsMap.entrySet()) {
            Field field = new Field();
            field.setDDMStructureId(ddmStructureId);
            field.setName(entry.getKey());
            field.addValue(locale, (Serializable)((Object)String.valueOf(entry.getValue())));
            if (create && !locale.equals(defaultLocale)) {
                field.addValue(defaultLocale, (Serializable)((Object)String.valueOf(entry.getValue())));
            }
            field.setDefaultLocale(defaultLocale);
            fields.put(field);
        }
        return fields;
    }

    protected void updateRecordVersion(User user, DDLRecordVersion recordVersion, String version, int displayIndex, int status, ServiceContext serviceContext) {
        recordVersion.setUserId(user.getUserId());
        recordVersion.setUserName(user.getFullName());
        recordVersion.setVersion(version);
        recordVersion.setDisplayIndex(displayIndex);
        recordVersion.setStatus(status);
        recordVersion.setStatusByUserId(user.getUserId());
        recordVersion.setStatusByUserName(user.getFullName());
        recordVersion.setStatusDate(serviceContext.getModifiedDate(null));
        this.ddlRecordVersionPersistence.update((BaseModel)recordVersion);
    }
}

