/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.search;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Collection;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class DDLRecordSetIndexer
extends BaseIndexer<DDLRecordSet> {
    public static final String CLASS_NAME = DDLRecordSet.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(DDLRecordSetIndexer.class);
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    private IndexerRegistry _indexerRegistry;

    public DDLRecordSetIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "uid"});
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    protected void doDelete(DDLRecordSet recordSet) throws Exception {
        this.deleteDocument(recordSet.getCompanyId(), recordSet.getRecordSetId());
    }

    protected Document doGetDocument(DDLRecordSet ddlRecordSet) throws Exception {
        return this.getBaseModelDocument(CLASS_NAME, (BaseModel)ddlRecordSet);
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        return this.createSummary(document, "title", "description");
    }

    protected void doReindex(DDLRecordSet recordSet) throws Exception {
        Document document = this.getDocument(recordSet);
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)recordSet.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
        this.reindexRecords(recordSet);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        DDLRecordSet recordSet = this._ddlRecordSetLocalService.getRecordSet(classPK);
        this.doReindex(recordSet);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexRecordSets(companyId);
    }

    protected void reindexRecords(DDLRecordSet recordSet) throws Exception {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(DDLRecord.class);
        indexer.reindex((Collection)recordSet.getRecords());
    }

    protected void reindexRecordSets(long companyId) throws Exception {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._ddlRecordSetLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DDLRecordSet>(){

            public void performAction(DDLRecordSet recordSet) throws PortalException {
                block3: {
                    try {
                        Document document = DDLRecordSetIndexer.this.getDocument(recordSet);
                        if (document != null) {
                            indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                        }
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn((Object)("Unable to index dynamic data lists record " + recordSet.getRecordSetId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetLocalService(DDLRecordSetLocalService ddlRecordSetLocalService) {
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
    }

    @Reference(unbind="-")
    protected void setIndexerRegistry(IndexerRegistry indexerRegistry) {
        this._indexerRegistry = indexerRegistry;
    }
}

