/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.lar;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.exportimport.content.processor.DDMFormValuesExportImportContentProcessor;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONSerializer;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class DDLRecordStagedModelDataHandler
extends BaseStagedModelDataHandler<DDLRecord> {
    public static final String[] CLASS_NAMES = new String[]{DDLRecord.class.getName()};
    private DDLRecordLocalService _ddlRecordLocalService;
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    private DDMFormValuesExportImportContentProcessor _ddmFormValuesExportImportContentProcessor;
    private DDMFormValuesJSONDeserializer _ddmFormValuesJSONDeserializer;
    private DDMFormValuesJSONSerializer _ddmFormValuesJSONSerializer;
    private StorageEngine _storageEngine;

    public void deleteStagedModel(DDLRecord record) throws PortalException {
        this._ddlRecordLocalService.deleteRecord(record);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DDLRecord record = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (record != null) {
            this.deleteStagedModel(record);
        }
    }

    public DDLRecord fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._ddlRecordLocalService.fetchDDLRecordByUuidAndGroupId(uuid, groupId);
    }

    public List<DDLRecord> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._ddlRecordLocalService.getDDLRecordsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDLRecord record) {
        return record.getUuid();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDLRecord record) throws Exception {
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)record, (StagedModel)record.getRecordSet(), (String)"strong");
        Element recordElement = portletDataContext.getExportDataElement((ClassedModel)record);
        this.exportDDMFormValues(portletDataContext, record, recordElement);
        portletDataContext.addClassedModel(recordElement, ExportImportPathUtil.getModelPath((StagedModel)record), (ClassedModel)record);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDLRecord record) throws Exception {
        long userId = portletDataContext.getUserId(record.getUserUuid());
        Map recordSetIds = portletDataContext.getNewPrimaryKeysMap(DDLRecordSet.class);
        long recordSetId = MapUtil.getLong((Map)recordSetIds, (long)record.getRecordSetId(), (long)record.getRecordSetId());
        Element recordElement = portletDataContext.getImportDataElement((StagedModel)record);
        DDMFormValues ddmFormValues = this.getImportDDMFormValues(portletDataContext, recordElement, recordSetId);
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)record);
        DDLRecord importedRecord = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DDLRecord existingRecord = this.fetchStagedModelByUuidAndGroupId(record.getUuid(), portletDataContext.getScopeGroupId());
            if (existingRecord == null) {
                serviceContext.setUuid(record.getUuid());
                importedRecord = this._ddlRecordLocalService.addRecord(userId, portletDataContext.getScopeGroupId(), recordSetId, record.getDisplayIndex(), ddmFormValues, serviceContext);
            } else {
                importedRecord = this._ddlRecordLocalService.updateRecord(userId, existingRecord.getRecordId(), false, record.getDisplayIndex(), ddmFormValues, serviceContext);
            }
        } else {
            importedRecord = this._ddlRecordLocalService.addRecord(userId, portletDataContext.getScopeGroupId(), recordSetId, record.getDisplayIndex(), ddmFormValues, serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)record, (ClassedModel)importedRecord);
    }

    protected void exportDDMFormValues(PortletDataContext portletDataContext, DDLRecord record, Element recordElement) throws Exception {
        String ddmFormValuesPath = ExportImportPathUtil.getModelPath((StagedModel)record, (String)"ddm-form-values.json");
        recordElement.addAttribute("ddm-form-values-path", ddmFormValuesPath);
        DDMFormValues ddmFormValues = this._storageEngine.getDDMFormValues(record.getDDMStorageId());
        ddmFormValues = this._ddmFormValuesExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)record, ddmFormValues, true, false);
        portletDataContext.addZipEntry(ddmFormValuesPath, this._ddmFormValuesJSONSerializer.serialize(ddmFormValues));
    }

    protected DDMFormValues getImportDDMFormValues(PortletDataContext portletDataContext, Element recordElement, long recordSetId) throws Exception {
        DDLRecordSet recordSet = this._ddlRecordSetLocalService.getRecordSet(recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        String ddmFormValuesPath = recordElement.attributeValue("ddm-form-values-path");
        String serializedDDMFormValues = portletDataContext.getZipEntryAsString(ddmFormValuesPath);
        DDMFormValues ddmFormValues = this._ddmFormValuesJSONDeserializer.deserialize(ddmStructure.getDDMForm(), serializedDDMFormValues);
        return this._ddmFormValuesExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)ddmStructure, ddmFormValues);
    }

    @Reference(unbind="-")
    protected void setDDLRecordLocalService(DDLRecordLocalService ddlRecordLocalService) {
        this._ddlRecordLocalService = ddlRecordLocalService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetLocalService(DDLRecordSetLocalService ddlRecordSetLocalService) {
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesExportImportContentProcessor(DDMFormValuesExportImportContentProcessor ddmFormValuesExportImportContentProcessor) {
        this._ddmFormValuesExportImportContentProcessor = ddmFormValuesExportImportContentProcessor;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesJSONDeserializer(DDMFormValuesJSONDeserializer ddmFormValuesJSONDeserializer) {
        this._ddmFormValuesJSONDeserializer = ddmFormValuesJSONDeserializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesJSONSerializer(DDMFormValuesJSONSerializer ddmFormValuesJSONSerializer) {
        this._ddmFormValuesJSONSerializer = ddmFormValuesJSONSerializer;
    }

    @Reference(unbind="-")
    protected void setStorageEngine(StorageEngine storageEngine) {
        this._storageEngine = storageEngine;
    }

    protected void validateExport(PortletDataContext portletDataContext, DDLRecord record) throws PortletDataException {
        int status = -1;
        try {
            status = record.getStatus();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
        if (!portletDataContext.isInitialPublication() && !ArrayUtil.contains((int[])this.getExportableStatuses(), (int)status)) {
            PortletDataException pde = new PortletDataException(9);
            pde.setStagedModel((StagedModel)record);
            throw pde;
        }
    }
}

