/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.instance.lifecycle;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.util.DefaultDDMStructureHelper;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.PortalUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalInstanceLifecycleListener.class})
public class AddDefaultDDLStructuresPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private DefaultDDMStructureHelper _defaultDDMStructureHelper;
    private GroupLocalService _groupLocalService;
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAddGroupPermissions(true);
        Group group = this._groupLocalService.getCompanyGroup(company.getCompanyId());
        serviceContext.setScopeGroupId(group.getGroupId());
        long defaultUserId = this._userLocalService.getDefaultUserId(company.getCompanyId());
        serviceContext.setUserId(defaultUserId);
        this._defaultDDMStructureHelper.addDDMStructures(defaultUserId, group.getGroupId(), PortalUtil.getClassNameId(DDLRecordSet.class), AddDefaultDDLStructuresPortalInstanceLifecycleListener.class.getClassLoader(), "com/liferay/dynamic/data/lists/events/dependencies/default-dynamic-data-lists-structures.xml", serviceContext);
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetLocalService(DDLRecordSetLocalService ddlRecordSetLocalService) {
    }

    @Reference(unbind="-")
    protected void setDefaultDDMStructureHelper(DefaultDDMStructureHelper defaultDDMStructureHelper) {
        this._defaultDDMStructureHelper = defaultDDMStructureHelper;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

