/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.exporter.impl;

import com.liferay.dynamic.data.lists.exporter.DDLExporter;
import com.liferay.dynamic.data.lists.exporter.impl.BaseDDLExporter;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.CSVUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDLExporter.class})
public class DDLCSVExporter
extends BaseDDLExporter {
    private DDLRecordLocalService _ddlRecordLocalService;
    private DDLRecordSetService _ddlRecordSetService;
    private DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    private StorageEngine _storageEngine;

    public String getFormat() {
        return "csv";
    }

    @Override
    protected byte[] doExport(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) throws Exception {
        StringBundler sb = new StringBundler();
        DDLRecordSet recordSet = this._ddlRecordSetService.getRecordSet(recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        List<DDMFormField> ddmFormFields = this.getDDMFormFields(ddmStructure);
        for (DDMFormField ddmFormField : ddmFormFields) {
            LocalizedValue label = ddmFormField.getLabel();
            sb.append(CSVUtil.encode((String)label.getString(this.getLocale())));
            sb.append(',');
        }
        sb.append(LanguageUtil.get((Locale)this.getLocale(), (String)"status"));
        sb.append("\n");
        List records = this._ddlRecordLocalService.getRecords(recordSetId, status, start, end, orderByComparator);
        Iterator iterator = records.iterator();
        while (iterator.hasNext()) {
            DDLRecord record = (DDLRecord)iterator.next();
            DDLRecordVersion recordVersion = record.getRecordVersion();
            DDMFormValues ddmFormValues = this._storageEngine.getDDMFormValues(recordVersion.getDDMStorageId());
            Fields fields = this._ddmFormValuesToFieldsConverter.convert(ddmStructure, ddmFormValues);
            for (DDMFormField ddmFormField : ddmFormFields) {
                String name = ddmFormField.getName();
                String value = "";
                if (fields.contains(name)) {
                    Field field = fields.get(name);
                    value = field.getRenderedValue(this.getLocale());
                }
                sb.append(CSVUtil.encode((String)value));
                sb.append(',');
            }
            sb.append(this.getStatusMessage(recordVersion.getStatus()));
            if (!iterator.hasNext()) continue;
            sb.append("\n");
        }
        String csv = sb.toString();
        return csv.getBytes();
    }

    @Reference(unbind="-")
    protected void setDDLRecordLocalService(DDLRecordLocalService ddlRecordLocalService) {
        this._ddlRecordLocalService = ddlRecordLocalService;
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetService(DDLRecordSetService ddlRecordSetService) {
        this._ddlRecordSetService = ddlRecordSetService;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesToFieldsConverter(DDMFormValuesToFieldsConverter ddmFormValuesToFieldsConverter) {
        this._ddmFormValuesToFieldsConverter = ddmFormValuesToFieldsConverter;
    }

    @Reference(unbind="-")
    protected void setStorageEngine(StorageEngine storageEngine) {
        this._storageEngine = storageEngine;
    }
}

