var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));

// ../../../../../../../../../$/bridge/for/main/@clayui/button
var button_exports = {};
__export(button_exports, {
  default: () => button_default
});
__reExport(button_exports, clayui_button_star);
import * as clayui_button_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$button.js";
import __default__ from "../../frontend-taglib-clay/__liferay__/exports/@clayui$button.js";
var button_default = __default__;

// ../../../../../../../../../$/bridge/for/main/@clayui/icon
var icon_exports = {};
__export(icon_exports, {
  default: () => icon_default
});
__reExport(icon_exports, clayui_icon_star);
import * as clayui_icon_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$icon.js";
import __default__2 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$icon.js";
var icon_default = __default__2;

// ../../../../../../../../../$/bridge/for/main/@clayui/loading-indicator
var loading_indicator_exports = {};
__export(loading_indicator_exports, {
  default: () => loading_indicator_default
});
__reExport(loading_indicator_exports, clayui_loading_indicator_star);
import * as clayui_loading_indicator_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$loading-indicator.js";
import __default__3 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$loading-indicator.js";
var loading_indicator_default = __default__3;

// ../../../../../../../../../$/bridge/for/main/@liferay/frontend-js-react-web
var frontend_js_react_web_exports = {};
__reExport(frontend_js_react_web_exports, liferay_star);
import * as liferay_star from "../../frontend-js-react-web/__liferay__/index.js";

// ../../../../../../../../../$/bridge/for/main/frontend-js-web
var frontend_js_web_exports = {};
__reExport(frontend_js_web_exports, liferay_star2);
import * as liferay_star2 from "../../frontend-js-web/__liferay__/index.js";

// ../../../../../../../../../$/bridge/for/main/image-promise
var image_promise_exports = {};
__export(image_promise_exports, {
  default: () => image_promise_default
});
__reExport(image_promise_exports, image_promise_star);
import * as image_promise_star from "../../frontend-js-dependencies-web/__liferay__/exports/image-promise.js";
import __default__4 from "../../frontend-js-dependencies-web/__liferay__/exports/image-promise.js";
var image_promise_default = __default__4;

// ../../../../../../../../../$/bridge/for/main/prop-types
var prop_types_exports = {};
__export(prop_types_exports, {
  default: () => prop_types_default
});
__reExport(prop_types_exports, prop_types_star);
import * as prop_types_star from "../../frontend-js-react-web/__liferay__/exports/prop-types.js";
import __default__5 from "../../frontend-js-react-web/__liferay__/exports/prop-types.js";
var prop_types_default = __default__5;

// ../../../../../../../../../$/bridge/for/main/react
var react_exports = {};
__export(react_exports, {
  default: () => react_default
});
__reExport(react_exports, react_star);
import * as react_star from "../../frontend-js-react-web/__liferay__/exports/react.js";
import __default__6 from "../../frontend-js-react-web/__liferay__/exports/react.js";
var react_default = __default__6;

// ../../../../../../../../../$/bridge/for/main/@liferay/document-library-preview-css
var document_library_preview_css_exports = {};
__reExport(document_library_preview_css_exports, liferay_star3);
import * as liferay_star3 from "../../document-library-preview-css/__liferay__/index.js";

// src/main/resources/META-INF/resources/preview/js/index.js
var KEY_CODE_ENTER = 13;
var KEY_CODE_ESC = 27;
var VALID_KEY_CODES = [
  8,
  9,
  37,
  38,
  39,
  40,
  46,
  48,
  49,
  50,
  51,
  52,
  53,
  54,
  55,
  56,
  57
];
var WAIT_BETWEEN_GO_TO_PAGE = 250;
var DocumentPreviewer = ({ baseImageURL, initialPage, totalPages }) => {
  const [currentPage, setCurrentPage] = (0, react_exports.useState)(initialPage);
  const [currentPageLoading, setCurrentPageLoading] = (0, react_exports.useState)(false);
  const [expanded, setExpanded] = (0, react_exports.useState)(false);
  const [loadedPages] = (0, react_exports.useState)({
    [currentPage]: {
      loaded: true,
      pagePromise: Promise.resolve()
    }
  });
  const [nextPageDisabled, setNextPageDisabled] = (0, react_exports.useState)(
    currentPage === totalPages
  );
  const [previousPageDisabled, setPreviousPageDisabled] = (0, react_exports.useState)(
    currentPage === 1
  );
  const [showPageInput, setShowPageInput] = (0, react_exports.useState)(false);
  const imageContainerRef = (0, react_exports.useRef)();
  const pageInputRef = (0, react_exports.useRef)();
  const showPageInputButtonRef = (0, react_exports.useRef)();
  const isMounted = (0, frontend_js_react_web_exports.useIsMounted)();
  if (showPageInput) {
    setTimeout(() => {
      if (isMounted()) {
        pageInputRef.current.focus();
      }
    }, 100);
  }
  const createImageURL = (page) => {
    const imageURL = new URL(baseImageURL);
    imageURL.searchParams.set("previewFileIndex", page);
    return imageURL.toString();
  };
  const loadPage = (page) => {
    let pagePromise = loadedPages[page] && loadedPages[page].pagePromise;
    if (!pagePromise) {
      pagePromise = image_promise_default(createImageURL(page)).then(() => {
        loadedPages[page].loaded = true;
      });
      loadedPages[page] = {
        loaded: false,
        pagePromise
      };
    }
    return pagePromise;
  };
  const loadAdjacentPages = (page, adjacentPageCount = 2) => {
    for (let i = 1; i <= adjacentPageCount; i++) {
      if (page + i <= totalPages) {
        loadPage(page + i);
      }
      if (page - i > 1) {
        loadPage(page - i);
      }
    }
  };
  const loadCurrentPage = (0, frontend_js_web_exports.debounce)((page) => {
    loadPage(page).then(() => {
      loadAdjacentPages(page);
      setCurrentPageLoading(false);
    }).catch(() => {
      setCurrentPageLoading(false);
    });
  }, WAIT_BETWEEN_GO_TO_PAGE);
  const goToPage = (page) => {
    setNextPageDisabled(page === totalPages);
    setPreviousPageDisabled(page === 1);
    if (!loadedPages[page] || !loadedPages[page].loaded) {
      setCurrentPageLoading(true);
      loadCurrentPage(page);
    }
    imageContainerRef.current.scrollTop = 0;
    setCurrentPage(page);
  };
  const processPageInput = (value) => {
    let pageNumber = Number.parseInt(value, 10);
    pageNumber = pageNumber ? Math.min(Math.max(1, pageNumber), totalPages) : currentPage;
    goToPage(pageNumber);
  };
  const hidePageInput = (returnFocus = true) => {
    setShowPageInput(false);
    if (returnFocus) {
      setTimeout(() => {
        if (isMounted()) {
          showPageInputButtonRef.current.focus();
        }
      }, 100);
    }
  };
  const handleBlurPageInput = (event) => {
    processPageInput(event.currentTarget.value);
    hidePageInput(false);
  };
  const handleKeyDownPageInput = (event) => {
    const code = event.keyCode || event.charCode;
    if (code === KEY_CODE_ENTER) {
      processPageInput(event.currentTarget.value);
      hidePageInput();
    } else if (code === KEY_CODE_ESC) {
      hidePageInput();
    } else if (VALID_KEY_CODES.indexOf(code) === -1) {
      event.preventDefault();
    }
  };
  (0, react_exports.useEffect)(() => {
    loadAdjacentPages(initialPage);
  }, []);
  return /* @__PURE__ */ react_default.createElement("div", { className: "preview-file" }, /* @__PURE__ */ react_default.createElement(
    "div",
    {
      className: "preview-file-container preview-file-max-height",
      ref: imageContainerRef
    },
    currentPageLoading ? /* @__PURE__ */ react_default.createElement(loading_indicator_default, null) : /* @__PURE__ */ react_default.createElement(
      "img",
      {
        className: `preview-file-document ${!expanded && "preview-file-document-fit"}`,
        src: createImageURL(currentPage)
      }
    )
  ), /* @__PURE__ */ react_default.createElement("div", { className: "preview-toolbar-container" }, /* @__PURE__ */ react_default.createElement(button_default.Group, { className: "floating-bar" }, /* @__PURE__ */ react_default.createElement(button_default.Group, null, /* @__PURE__ */ react_default.createElement(
    button_default,
    {
      className: "btn-floating-bar btn-floating-bar-text",
      onClick: () => {
        setShowPageInput(true);
      },
      ref: showPageInputButtonRef,
      title: totalPages > 1 && Liferay.Language.get("click-to-jump-to-a-page")
    },
    `${Liferay.Language.get(
      "page"
    )} ${currentPage} / ${totalPages}`
  ), showPageInput && /* @__PURE__ */ react_default.createElement("div", { className: "floating-bar-input-wrapper" }, /* @__PURE__ */ react_default.createElement(
    "input",
    {
      className: "floating-bar-input form-control form-control-sm",
      max: totalPages,
      min: "1",
      onBlur: handleBlurPageInput,
      onKeyDown: handleKeyDownPageInput,
      placeholder: Liferay.Language.get(
        "page-..."
      ),
      ref: pageInputRef,
      type: "number"
    }
  ))), /* @__PURE__ */ react_default.createElement(
    button_default,
    {
      className: "btn-floating-bar",
      disabled: previousPageDisabled,
      monospaced: true,
      onClick: () => {
        goToPage(currentPage - 1);
      },
      title: Liferay.Language.get("page-above")
    },
    /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "caret-top" })
  ), /* @__PURE__ */ react_default.createElement(
    button_default,
    {
      className: "btn-floating-bar",
      disabled: nextPageDisabled,
      monospaced: true,
      onClick: () => {
        goToPage(currentPage + 1);
      },
      title: Liferay.Language.get("page-below")
    },
    /* @__PURE__ */ react_default.createElement(icon_default, { symbol: "caret-bottom" })
  ), /* @__PURE__ */ react_default.createElement("div", { className: "separator-floating-bar" }), /* @__PURE__ */ react_default.createElement(
    button_default,
    {
      className: "btn-floating-bar",
      monospaced: true,
      onClick: () => {
        setExpanded(!expanded);
      },
      title: expanded ? Liferay.Language.get("zoom-to-fit") : Liferay.Language.get("expand")
    },
    /* @__PURE__ */ react_default.createElement(
      icon_default,
      {
        symbol: expanded ? "autosize" : "full-size"
      }
    )
  ))));
};
DocumentPreviewer.propTypes = {
  baseImageURL: prop_types_default.string,
  initialPage: prop_types_default.number,
  totalPages: prop_types_default.number
};
export {
  DocumentPreviewer
};
//# sourceMappingURL=index.js.map
