Liferay.Loader.define("document-library-preview-document@2.0.14/preview/js/DocumentPreviewer.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/loading-indicator', 'frontend-js-react-web', 'frontend-js-web', 'document-library-preview-document$image-promise', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _frontendJsWeb = require("frontend-js-web");

  var _imagePromise = _interopRequireDefault(require("document-library-preview-document$image-promise"));

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var KEY_CODE_ENTER = 13;
  var KEY_CODE_ESC = 27;
  /**
   * Valid list of keycodes
   * Includes backspace, tab, arrows, delete and numbers
   * @type {Array<number>}
   */

  var VALID_KEY_CODES = [8, 9, 37, 38, 39, 40, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57];
  /**
   * Milisecons between goToPage calls
   * @type {number}
   */

  var WAIT_BETWEEN_GO_TO_PAGE = 250;
  /**
   * Component that creates a pdf preview
   * @review
   */

  var DocumentPreviewer = function DocumentPreviewer(_ref) {
    var baseImageURL = _ref.baseImageURL,
        initialPage = _ref.initialPage,
        totalPages = _ref.totalPages;

    var _useState = (0, _react.useState)(initialPage),
        _useState2 = _slicedToArray(_useState, 2),
        currentPage = _useState2[0],
        setCurrentPage = _useState2[1];

    var _useState3 = (0, _react.useState)(false),
        _useState4 = _slicedToArray(_useState3, 2),
        currentPageLoading = _useState4[0],
        setCurrentPageLoading = _useState4[1];

    var _useState5 = (0, _react.useState)(false),
        _useState6 = _slicedToArray(_useState5, 2),
        expanded = _useState6[0],
        setExpanded = _useState6[1];

    var _useState7 = (0, _react.useState)(_defineProperty({}, currentPage, {
      loaded: true,
      pagePromise: Promise.resolve()
    })),
        _useState8 = _slicedToArray(_useState7, 1),
        loadedPages = _useState8[0];

    var _useState10 = (0, _react.useState)(currentPage === totalPages),
        _useState11 = _slicedToArray(_useState10, 2),
        nextPageDisabled = _useState11[0],
        setNextPageDisabled = _useState11[1];

    var _useState12 = (0, _react.useState)(currentPage === 1),
        _useState13 = _slicedToArray(_useState12, 2),
        previousPageDisabled = _useState13[0],
        setPreviousPageDisabled = _useState13[1];

    var _useState14 = (0, _react.useState)(false),
        _useState15 = _slicedToArray(_useState14, 2),
        showPageInput = _useState15[0],
        setShowPageInput = _useState15[1];

    var imageContainer = (0, _react.useRef)();
    var pageInput = (0, _react.useRef)();
    var showPageInputButton = (0, _react.useRef)();

    if (showPageInput) {
      setTimeout(function () {
        if (isMounted()) {
          pageInput.current.focus();
        }
      }, 100);
    }

    var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

    var goToPage = function goToPage(page) {
      setNextPageDisabled(page === totalPages);
      setPreviousPageDisabled(page === 1);

      if (!loadedPages[page] || !loadedPages[page].loaded) {
        setCurrentPageLoading(true);
        loadCurrentPage(page);
      }

      imageContainer.current.scrollTop = 0;
      setCurrentPage(page);
    };

    var hidePageInput = function hidePageInput() {
      var returnFocus = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
      setShowPageInput(false);

      if (returnFocus) {
        setTimeout(function () {
          if (isMounted()) {
            showPageInputButton.current.focus();
          }
        }, 100);
      }
    };

    var loadPage = function loadPage(page) {
      var pagePromise = loadedPages[page] && loadedPages[page].pagePromise;

      if (!pagePromise) {
        pagePromise = (0, _imagePromise["default"])("".concat(baseImageURL).concat(page)).then(function () {
          loadedPages[page].loaded = true;
        });
        loadedPages[page] = {
          loaded: false,
          pagePromise: pagePromise
        };
      }

      return pagePromise;
    };

    var loadAdjacentPages = function loadAdjacentPages(page) {
      var adjacentPageCount = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;

      for (var i = 1; i <= adjacentPageCount; i++) {
        if (page + i <= totalPages) {
          loadPage(page + i);
        }

        if (page - i > 1) {
          loadPage(page - i);
        }
      }
    };

    var loadCurrentPage = (0, _frontendJsWeb.debounce)(function (page) {
      loadPage(page).then(function () {
        loadAdjacentPages(page);
        setCurrentPageLoading(false);
      })["catch"](function () {
        setCurrentPageLoading(false);
      });
    }, WAIT_BETWEEN_GO_TO_PAGE);

    var processPageInput = function processPageInput(value) {
      var pageNumber = Number.parseInt(value, 10);
      pageNumber = pageNumber ? Math.min(Math.max(1, pageNumber), totalPages) : currentPage;
      goToPage(pageNumber);
    };

    (0, _react.useEffect)(function () {
      loadAdjacentPages(initialPage); // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    return _react["default"].createElement("div", {
      className: "preview-file"
    }, _react["default"].createElement("div", {
      className: "preview-file-container preview-file-max-height",
      ref: imageContainer
    }, currentPageLoading ? _react["default"].createElement(_loadingIndicator["default"], null) : _react["default"].createElement("img", {
      className: "preview-file-document ".concat(!expanded && 'preview-file-document-fit'),
      src: "".concat(baseImageURL).concat(currentPage)
    })), _react["default"].createElement("div", {
      className: "preview-toolbar-container"
    }, _react["default"].createElement(_button["default"].Group, {
      className: "floating-bar"
    }, _react["default"].createElement(_button["default"].Group, null, _react["default"].createElement(_button["default"], {
      className: "btn-floating-bar btn-floating-bar-text",
      onClick: function onClick() {
        setShowPageInput(true);
      },
      ref: showPageInputButton,
      title: totalPages > 1 && Liferay.Language.get('click-to-jump-to-a-page')
    }, "".concat(Liferay.Language.get('page'), " ").concat(currentPage, " / ").concat(totalPages)), showPageInput && _react["default"].createElement("div", {
      className: "floating-bar-input-wrapper"
    }, _react["default"].createElement("input", {
      className: "floating-bar-input form-control form-control-sm",
      max: totalPages,
      min: "1",
      onBlur: function handleBlurPageInput(event) {
        processPageInput(event.currentTarget.value);
        hidePageInput(false);
      },
      onKeyDown: function handleKeyDownPageInput(event) {
        var code = event.keyCode || event.charCode;

        if (code === KEY_CODE_ENTER) {
          processPageInput(event.currentTarget.value);
          hidePageInput();
        } else if (code === KEY_CODE_ESC) {
          hidePageInput();
        } else if (VALID_KEY_CODES.indexOf(code) === -1) {
          event.preventDefault();
        }
      },
      placeholder: Liferay.Language.get('page-...'),
      ref: pageInput,
      type: "number"
    }))), _react["default"].createElement(_button["default"], {
      className: "btn-floating-bar",
      disabled: previousPageDisabled,
      monospaced: true,
      onClick: function onClick() {
        goToPage(currentPage - 1);
      },
      title: Liferay.Language.get('page-above')
    }, _react["default"].createElement(_icon["default"], {
      symbol: "caret-top"
    })), _react["default"].createElement(_button["default"], {
      className: "btn-floating-bar",
      disabled: nextPageDisabled,
      monospaced: true,
      onClick: function onClick() {
        goToPage(currentPage + 1);
      },
      title: Liferay.Language.get('page-below')
    }, _react["default"].createElement(_icon["default"], {
      symbol: "caret-bottom"
    })), _react["default"].createElement("div", {
      className: "separator-floating-bar"
    }), _react["default"].createElement(_button["default"], {
      className: "btn-floating-bar",
      monospaced: true,
      onClick: function onClick() {
        setExpanded(!expanded);
      },
      title: expanded ? Liferay.Language.get('zoom-to-fit') : Liferay.Language.get('expand')
    }, _react["default"].createElement(_icon["default"], {
      symbol: expanded ? 'autosize' : 'full-size'
    })))));
  };

  var _default = DocumentPreviewer;
  exports["default"] = _default;
  //# sourceMappingURL=DocumentPreviewer.es.js.map
});
//# sourceMappingURL=DocumentPreviewer.es.js.map