"use strict";

Liferay.Loader.define("document-library-preview-document@1.0.9/preview/js/DocumentPreviewer.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-debounce', 'frontend-js-metal-web$metal-component', 'document-library-preview-document$image-promise', 'frontend-js-metal-web$metal-soy', 'frontend-taglib-clay$clay-button', './DocumentPreviewer.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.DocumentPreviewer = void 0;

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalDebounce = require("frontend-js-metal-web$metal-debounce");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _imagePromise = _interopRequireDefault(require("document-library-preview-document$image-promise"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  require("frontend-taglib-clay$clay-button");

  var _DocumentPreviewer = _interopRequireDefault(require("./DocumentPreviewer.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var KEY_CODE_ENTER = 13;
  var KEY_CODE_ESC = 27;
  /**
   * Valid list of keycodes
   * Includes backspace, tab, arrows, delete and numbers
   * @type {Array<number>}
   */

  var VALID_KEY_CODES = [8, 9, 37, 38, 39, 40, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57];
  /**
   * Milisecons between goToPage calls
   * @type {number}
   */

  var WAIT_BETWEEN_GO_TO_PAGE = 250;
  /**
   * Component that create an pdf preview
   * @review
   */

  var DocumentPreviewer =
  /*#__PURE__*/
  function (_Component) {
    _inherits(DocumentPreviewer, _Component);

    function DocumentPreviewer() {
      _classCallCheck(this, DocumentPreviewer);

      return _possibleConstructorReturn(this, _getPrototypeOf(DocumentPreviewer).apply(this, arguments));
    }

    _createClass(DocumentPreviewer, [{
      key: "created",

      /**
       * @inheritDoc
       */
      value: function created() {
        this._loadedPages = _defineProperty({}, this.currentPage, {
          loaded: true,
          pagePromise: Promise.resolve()
        });

        this._loadPages(this.currentPage);

        this._goToPageDebounced = (0, _metalDebounce.debounce)(this._goToPage.bind(this), WAIT_BETWEEN_GO_TO_PAGE);
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "rendered",
      value: function rendered() {
        var _this = this;

        if (this.showPageInput) {
          setTimeout(function () {
            return _this.refs.pageInput.focus();
          }, 100);
        }
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "syncCurrentPage",
      value: function syncCurrentPage(currentPage) {
        this.refs.imageContainer.scrollTop = 0;
        this.previousPageDisabled = currentPage === 1;
        this.nextPageDisabled = currentPage === this.totalPages;

        if (!this._loadedPages[currentPage] || !this._loadedPages[currentPage].loaded) {
          this.currentPageLoading = true;

          this._goToPageDebounced(currentPage);
        } else {
          this.currentPageLoading = false;
        }
      }
      /**
       * Load adjacent pages of the initial one
       * @param {number|string} initialPage - the initial page
       * @param {number} [numberOfPages=2] - number of load pages (before and after)
       * @private
       * @review
       */

    }, {
      key: "_loadPages",
      value: function _loadPages(initialPage) {
        var numberOfPages = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;

        for (var i = 1; i <= numberOfPages; i++) {
          if (initialPage + i <= this.totalPages) {
            this._loadPage(initialPage + i);
          }

          if (initialPage - i > 1) {
            this._loadPage(initialPage - i);
          }
        }
      }
      /**
       * Trigger a promise to load the image
       * @param {number} page
       * @return {Promise} A promise to be resolved when the image is loaded
       * @private
       * @review
       */

    }, {
      key: "_loadPage",
      value: function _loadPage(page) {
        var _this2 = this;

        var pagePromise = this._loadedPages[page] && this._loadedPages[page].pagePromise;

        if (!pagePromise) {
          pagePromise = (0, _imagePromise.default)("".concat(this.baseImageURL).concat(page)).then(function () {
            _this2._loadedPages[page].loaded = true;
          });
          this._loadedPages[page] = {
            loaded: false,
            pagePromise: pagePromise
          };
        }

        return pagePromise;
      }
      /**
       * Show page when it's completely loaded
       * and load the closest pages
       * @param {number} page
       * @private
       * @review
       */

    }, {
      key: "_goToPage",
      value: function _goToPage(page) {
        var _this3 = this;

        this._loadPage(page).then(function () {
          if (page === _this3.currentPage) {
            _this3.currentPageLoading = false;

            _this3._loadPages(page);
          }
        });
      }
      /**
       * Event handler executed on pageInput blur.
       * Saves the current value.
       * @param {!Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleBlurPageInput",
      value: function _handleBlurPageInput(event) {
        this.currentPage = event.delegateTarget.value;

        this._hidePageInput(false);
      }
      /**
       * Handles click action in the toolbar.
       *
       * @param {!Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleClickToolbar",
      value: function _handleClickToolbar(event) {
        var action = event.currentTarget.value;

        if (action === 'expandToggle') {
          this.expanded = !this.expanded;
        } else if (action === 'go') {
          this.showPageInput = true;
        } else if (action === 'next') {
          this.currentPage++;
        } else if (action === 'previous') {
          this.currentPage--;
        }
      }
      /**
       * Prevents from introducing non digits in input field.
       * And map certain actions to escape enter (save) or (cancel)
       * @param {KeyboardEvent} event The keyboard event.
       * @private
       * @review
       */

    }, {
      key: "_handleKeyDownPageInput",
      value: function _handleKeyDownPageInput(event) {
        var code = event.keyCode || event.charCode;

        if (code === KEY_CODE_ENTER) {
          this.currentPage = event.delegateTarget.value;

          this._hidePageInput();
        } else if (code === KEY_CODE_ESC) {
          this._hidePageInput();
        } else if (VALID_KEY_CODES.indexOf(code) === -1) {
          event.preventDefault();
        }
      }
      /**
       * Hide PageInput and return focus to parent button
       * Saves the current value.
       * @param {Boolean} [returnFocus=true] - flag to determine if return the focus
       * @private
       * @review
       */

    }, {
      key: "_hidePageInput",
      value: function _hidePageInput() {
        var _this4 = this;

        var returnFocus = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
        this.showPageInput = false;

        if (returnFocus) {
          setTimeout(function () {
            return _this4.refs.showPageInputBtn.element.focus();
          }, 100);
        }
      }
      /**
       * Set the current page if is valid page and show loader
       * @param {number|string} page
       * @private
       * @review
       */

    }, {
      key: "_setCurrentPage",
      value: function _setCurrentPage(page) {
        var pageNumber = Number.parseInt(page, 10);
        return pageNumber ? Math.min(Math.max(1, pageNumber), this.totalPages) : this.currentPage;
      }
    }]);

    return DocumentPreviewer;
  }(_metalComponent.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.DocumentPreviewer = DocumentPreviewer;
  DocumentPreviewer.STATE = {
    /**
     * Base path to page images.
     * @type {String}
     */
    baseImageURL: _metalState.Config.string().required(),

    /**
     * Current page
     * @type {Number}
     */
    currentPage: _metalState.Config.oneOfType([_metalState.Config.number(), _metalState.Config.string()]).required().setter('_setCurrentPage'),

    /**
     * Flag that indicate if currentPgae is loading.
     * @type {Boolean}
     */
    currentPageLoading: _metalState.Config.bool().internal(),

    /**
     * Flag that indicate if pdf is expanded or fit to container.
     * @type {Boolean}
     */
    expanded: _metalState.Config.bool().internal(),

    /**
     * Flag that indicate if 'next page' is disabled.
     * @type {Boolean}
     */
    nextPageDisabled: _metalState.Config.bool().internal(),

    /**
     * Flag that indicate if 'previous page' is disabled.
     * @type {Boolean}
     */
    previousPageDisabled: _metalState.Config.bool().internal(),

    /**
     * Flag that indicate if 'pageInput' is visible.
     * @type {Boolean}
     */
    showPageInput: _metalState.Config.bool().internal(),

    /**
     * Path to icon images.
     * @type {String}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * Pdf pages lenght
     * @type {Number}
     */
    totalPages: _metalState.Config.number().required()
  };

  _metalSoy.default.register(DocumentPreviewer, _DocumentPreviewer.default);

  var _default = DocumentPreviewer;
  exports.default = _default;
  //# sourceMappingURL=DocumentPreviewer.es.js.map
});
//# sourceMappingURL=DocumentPreviewer.es.js.map