Liferay.Loader.define('document-library-preview-document$liferay-amd-loader@4.0.0/bin/demo-server', ['module', 'exports', 'require', 'document-library-preview-document$fs', 'document-library-preview-document$http', 'document-library-preview-document$path', 'frontend-js-node-shims$url'], function (module, exports, require) {
	var define = undefined;
	/**
  * © 2014 Liferay, Inc. <https://liferay.com>
  *
  * SPDX-License-Identifier: LGPL-3.0-or-later
  */

	const fs = require('document-library-preview-document$fs');
	const http = require('document-library-preview-document$http');
	const path = require('document-library-preview-document$path');
	const url = require('frontend-js-node-shims$url');

	const processResource = (resource, res) => {
		fs.createReadStream(path.join('build', 'demo', resource)).pipe(res);
	};

	const processModules = (resource, res) => {
		const params = url.parse(resource, true);

		let modules = params.query.modules;

		modules = modules.replace(/[,/]/g, '_');

		const filePath = path.join('build', 'demo', 'resolutions', modules + '.json');

		fs.createReadStream(filePath).pipe(res);
	};

	const server = http.createServer((req, res) => {
		let resource = req.url;

		if (resource === '/') {
			resource = '/index.html';
		}

		if (resource.startsWith('/o/js_resolve_modules')) {
			processModules(resource, res);
		} else if (fs.existsSync(path.join('build', 'demo', resource))) {
			processResource(resource, res);
		} else {
			res.end();
		}
	});

	server.listen(8080, 'localhost', () => {
		/* eslint-disable no-console */
		console.log('Starting up http-server');
		console.log('Available on:');
		console.log('http://localhost:8080');
		console.log('Hit CTRL - C to stop the server');
	});
});
//# sourceMappingURL=demo-server.js.map