/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.preview.document.internal;

import com.liferay.document.library.kernel.util.DLProcessorRegistryUtil;
import com.liferay.document.library.kernel.util.PDFProcessorUtil;
import com.liferay.document.library.preview.DLPreviewRenderer;
import com.liferay.document.library.preview.DLPreviewRendererProvider;
import com.liferay.document.library.preview.exception.DLFileEntryPreviewGenerationException;
import com.liferay.document.library.preview.exception.DLPreviewGenerationInProcessException;
import com.liferay.document.library.preview.exception.DLPreviewSizeException;
import com.liferay.document.library.service.DLFileVersionPreviewLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileVersion;
import java.util.Optional;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"content.type=application/msword", "content.type=application/pdf", "content.type=application/text", "content.type=application/vnd.ms-excel", "content.type=application/vnd.ms-powerpoint", "content.type=application/x-pdf", "content.type=text/html", "content.type=text/plain", "content.type=application/rtf", "content.type=application/vnd.oasis.opendocument.graphics", "content.type=application/vnd.oasis.opendocument.presentation", "content.type=application/vnd.oasis.opendocument.spreadsheet", "content.type=application/vnd.oasis.opendocument.text", "content.type=application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "content.type=application/vnd.openxmlformats-officedocument.wordprocessingml.document", "content.type=application/vnd.sun.xml.calc", "content.type=application/vnd.sun.xml.writer", "content.type=application/wordperfect", "content.type=text/rtf"}, service={DLPreviewRendererProvider.class})
public class DocumentPreviewRendererProvider
implements DLPreviewRendererProvider {
    @Reference
    private DLFileVersionPreviewLocalService _dlFileVersionPreviewLocalService;
    @Reference(target="(osgi.web.symbolicname=com.liferay.document.library.preview.document)")
    private ServletContext _servletContext;

    public Optional<DLPreviewRenderer> getPreviewDLPreviewRendererOptional(FileVersion fileVersion) {
        if (!PDFProcessorUtil.isDocumentSupported((FileVersion)fileVersion)) {
            return Optional.empty();
        }
        return Optional.of((request, response) -> {
            this.checkForPreviewGenerationExceptions(fileVersion);
            RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher("/preview/view.jsp");
            request.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", (Object)fileVersion);
            requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
        });
    }

    public Optional<DLPreviewRenderer> getThumbnailDLPreviewRendererOptional(FileVersion fileVersion) {
        return Optional.empty();
    }

    protected void checkForPreviewGenerationExceptions(FileVersion fileVersion) throws PortalException {
        if (this._dlFileVersionPreviewLocalService.hasDLFileVersionPreview(fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), 1)) {
            throw new DLFileEntryPreviewGenerationException();
        }
        if (!PDFProcessorUtil.hasImages((FileVersion)fileVersion)) {
            if (!DLProcessorRegistryUtil.isPreviewableSize((FileVersion)fileVersion)) {
                throw new DLPreviewSizeException();
            }
            throw new DLPreviewGenerationInProcessException();
        }
    }
}

