/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.document.conversion.internal.security.auth.verifier;

import com.liferay.document.library.document.conversion.internal.security.auth.verifier.ImageRequestAuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.auth.AuthVerifierPipeline;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.liferay.document.library.document.conversion.internal.security.auth.verifier.image.request.module.configuration.ImageRequestAuthVerifierConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class ImageRequestAuthVerifierPublisher {
    private ServiceRegistration<AuthVerifier> _authVerifierServiceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        Boolean enabled = GetterUtil.getBoolean((Object)properties.get("enabled"));
        if (enabled == null || !enabled.booleanValue()) {
            return;
        }
        ImageRequestAuthVerifier authVerifier = new ImageRequestAuthVerifier();
        Class clazz = authVerifier.getClass();
        String authVerifierPropertyName = AuthVerifierPipeline.getAuthVerifierPropertyName((String)clazz.getName());
        Hashtable<String, Object> authVerifierProperties = new Hashtable<String, Object>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = this._translate(authVerifierPropertyName, entry.getKey());
            ((Dictionary)authVerifierProperties).put(key, entry.getValue());
        }
        this._authVerifierServiceRegistration = bundleContext.registerService(AuthVerifier.class, (Object)authVerifier, authVerifierProperties);
    }

    @Deactivate
    protected void deactivate() {
        if (this._authVerifierServiceRegistration != null) {
            this._authVerifierServiceRegistration.unregister();
            this._authVerifierServiceRegistration = null;
        }
    }

    private String _translate(String authVerifierPropertyName, String key) {
        if (key.equals("hostsAllowed")) {
            key = "hosts.allowed";
        } else if (key.equals("urlsExcludes")) {
            key = "urls.excludes";
        } else if (key.equals("urlsIncludes")) {
            key = "urls.includes";
        }
        return authVerifierPropertyName + key;
    }
}

